/*
 * Decompiled with CFR 0.152.
 */
package com.bfb.merchant.utils;

import com.bfb.merchant.utils.HttpSendResult;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpClientError;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleHttpsClient {
    private Map<Integer, Integer> registerPortList = new HashMap<Integer, Integer>();

    public SimpleHttpsClient() {
        Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new SimpleHttpsSocketFactory(), 443));
        this.registerPort(443);
    }

    public HttpSendResult postRequest(String url, Map<String, String> params, int timeout, String characterSet) {
        if (characterSet == null || "".equals(characterSet)) {
            characterSet = "UTF-8";
        }
        HttpSendResult result = new HttpSendResult();
        PostMethod postMethod = new PostMethod(url);
        postMethod.setRequestHeader("Connection", "close");
        postMethod.addRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=" + characterSet);
        NameValuePair[] data = this.createNameValuePair(params);
        postMethod.setRequestBody(data);
        Integer port = this.getPort(url);
        if (this.isRegisterPort(port)) {
            Protocol myhttps = new Protocol("https", (ProtocolSocketFactory)new SimpleHttpsSocketFactory(), port.intValue());
            Protocol.registerProtocol((String)"https ", (Protocol)myhttps);
            this.registerPort(port);
        }
        HttpClient client = new HttpClient();
        client.getParams().setSoTimeout(timeout);
        try {
            try {
                int status = client.executeMethod((HttpMethod)postMethod);
                InputStream is = postMethod.getResponseBodyAsStream();
                String responseBody = IOUtils.toString((InputStream)is, (String)characterSet);
                result.setStatus(status);
                result.setResponseBody(responseBody);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                postMethod.releaseConnection();
            }
        }
        finally {
            postMethod.releaseConnection();
        }
        return result;
    }

    public HttpSendResult postRequest(String url, Map<String, String> params, int timeout) {
        return this.postRequest(url, params, timeout, "UTF-8");
    }

    public HttpSendResult getRequest(String url, Map<String, String> params, int timeout, String characterSet) {
        if (characterSet == null || "".equals(characterSet)) {
            characterSet = "UTF-8";
        }
        HttpSendResult result = new HttpSendResult();
        Integer port = this.getPort(url);
        if (this.isRegisterPort(port)) {
            Protocol myhttps = new Protocol("https", (ProtocolSocketFactory)new SimpleHttpsSocketFactory(), port.intValue());
            Protocol.registerProtocol((String)"https ", (Protocol)myhttps);
            this.registerPort(port);
        }
        url = this.appendUrlParam(url, params);
        HttpClient httpclient = new HttpClient();
        GetMethod httpget = new GetMethod(url);
        try {
            try {
                int status = httpclient.executeMethod((HttpMethod)httpget);
                InputStream is = httpget.getResponseBodyAsStream();
                String responseBody = IOUtils.toString((InputStream)is, (String)characterSet);
                result.setStatus(status);
                result.setResponseBody(responseBody);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                httpget.releaseConnection();
            }
        }
        finally {
            httpget.releaseConnection();
        }
        return result;
    }

    public HttpSendResult getRequest(String url, Map<String, String> params, int timeout) {
        return this.getRequest(url, params, timeout, "UTF-8");
    }

    private boolean isRegisterPort(Integer port) {
        return this.registerPortList.get(port) != null;
    }

    private void registerPort(Integer port) {
        this.registerPortList.put(port, port);
    }

    private Integer getPort(String uri) {
        try {
            URL url = new URL(uri);
            int port = url.getPort();
            if (port == -1) {
                port = uri.indexOf("https://") == 0 ? 443 : 80;
            }
            return port;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private NameValuePair[] createNameValuePair(Map<String, String> params) {
        NameValuePair[] pairs = new NameValuePair[params.size()];
        int index = 0;
        for (String key : params.keySet()) {
            pairs[index++] = new NameValuePair(key, params.get(key));
        }
        return pairs;
    }

    private String appendUrlParam(String url, Map<String, String> params) {
        String result = "";
        result = url.contains("?") && url.contains("=") ? String.valueOf(url) + "&" : String.valueOf(url) + "?";
        for (String key : params.keySet()) {
            result = String.valueOf(result) + key + "=" + params.get(key) + "&";
        }
        if (result.charAt(result.length() - 1) == '&') {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private class SimpleHttpsSocketFactory
    implements ProtocolSocketFactory {
        private SSLContext sslcontext = null;

        private SSLContext createEasySSLContext() {
            try {
                X509TrustManager trustMgr = new X509TrustManager(){

                    public void checkClientTrusted(X509Certificate[] ax509certificate, String s) throws CertificateException {
                    }

                    public void checkServerTrusted(X509Certificate[] ax509certificate, String s) throws CertificateException {
                    }

                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                };
                TrustManager[] trustMgrs = new TrustManager[]{trustMgr};
                SSLContext context = SSLContext.getInstance("SSL");
                context.init(null, trustMgrs, null);
                return context;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new HttpClientError(e.toString());
            }
        }

        private SSLContext getSSLContext() {
            if (this.sslcontext == null) {
                this.sslcontext = this.createEasySSLContext();
            }
            return this.sslcontext;
        }

        public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
            return this.getSSLContext().getSocketFactory().createSocket(host, port, clientHost, clientPort);
        }

        public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
            if (params == null) {
                throw new IllegalArgumentException("Parameters may not be null");
            }
            int timeout = params.getConnectionTimeout();
            SSLSocketFactory socketfactory = this.getSSLContext().getSocketFactory();
            if (timeout == 0) {
                return socketfactory.createSocket(host, port, localAddress, localPort);
            }
            Socket socket = socketfactory.createSocket();
            InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
            InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
            socket.bind(localaddr);
            socket.connect(remoteaddr, timeout);
            return socket;
        }

        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return this.getSSLContext().getSocketFactory().createSocket(host, port);
        }

        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
            return this.getSSLContext().getSocketFactory().createSocket(socket, host, port, autoClose);
        }

        public boolean equals(Object obj) {
            return obj != null && obj.getClass().equals(SSLSocketFactory.class);
        }

        public int hashCode() {
            return SimpleHttpsSocketFactory.class.hashCode();
        }
    }
}

