/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration;

import com.dianping.cat.message.Message;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.spi.MessageTree;
import java.util.ArrayList;
import java.util.List;
import org.unidal.helper.Splitters;

public class AtomicTreeParser {
    private List<String> m_startTypes = new ArrayList<String>();
    private List<String> m_matchTypes = new ArrayList<String>();

    public void init(String startTypes, String matchTypes) {
        if (startTypes != null) {
            this.m_startTypes = Splitters.by((String)";").noEmptyItem().split(startTypes);
        }
        if (matchTypes != null) {
            this.m_matchTypes = Splitters.by((String)";").noEmptyItem().split(matchTypes);
        }
    }

    public boolean isAtomicMessage(MessageTree tree) {
        Message message = tree.getMessage();
        if (message instanceof Transaction) {
            String type = message.getType();
            if (this.m_startTypes != null) {
                for (String s : this.m_startTypes) {
                    if (!type.startsWith(s)) continue;
                    return true;
                }
            }
            if (this.m_matchTypes != null) {
                return this.m_matchTypes.contains(type);
            }
            return false;
        }
        return true;
    }
}

