/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.AtomicTreeParser;
import com.dianping.cat.configuration.ClientConfigManager;
import com.dianping.cat.configuration.ClientConfigMerger;
import com.dianping.cat.configuration.ClientConfigValidator;
import com.dianping.cat.configuration.KVConfig;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.configuration.client.entity.ClientConfig;
import com.dianping.cat.configuration.client.entity.Domain;
import com.dianping.cat.configuration.client.entity.Server;
import com.dianping.cat.configuration.client.transform.DefaultSaxParser;
import com.dianping.cat.message.spi.MessageTree;
import com.site.helper.JsonBuilder;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.helper.Files;
import org.unidal.helper.Urls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClientConfigManager
implements LogEnabled,
ClientConfigManager,
Initializable {
    private static final String PROPERTIES_FILE = "/META-INF/app.properties";
    private static final String XML = "/data/appdatas/cat/client.xml";
    private ClientConfig m_config;
    private volatile double m_sample = 1.0;
    private volatile boolean m_block = false;
    private String m_routers;
    private JsonBuilder m_jsonBuilder = new JsonBuilder();
    private AtomicTreeParser m_atomicTreeParser = new AtomicTreeParser();
    private Logger m_logger;

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    @Override
    public Domain getDomain() {
        Domain domain = null;
        if (this.m_config != null) {
            Map<String, Domain> domains = this.m_config.getDomains();
            Domain domain2 = domain = domains.isEmpty() ? null : domains.values().iterator().next();
        }
        if (domain != null) {
            return domain;
        }
        return new Domain("UNKNOWN").setEnabled(false);
    }

    @Override
    public int getMaxMessageLength() {
        if (this.m_config == null) {
            return 5000;
        }
        return this.getDomain().getMaxMessageSize();
    }

    @Override
    public String getRouters() {
        if (this.m_routers == null) {
            this.refreshConfig();
        }
        return this.m_routers;
    }

    @Override
    public double getSampleRatio() {
        return this.m_sample;
    }

    private String getServerConfigUrl() {
        if (this.m_config == null) {
            return null;
        }
        List<Server> servers = this.m_config.getServers();
        int size = servers.size();
        int index = (int)((double)size * Math.random());
        if (index >= 0 && index < size) {
            Server server = servers.get(index);
            Integer httpPort = server.getHttpPort();
            if (httpPort == null || httpPort == 0) {
                httpPort = 8080;
            }
            return String.format("http://%s:%d/cat/s/router?domain=%s&ip=%s&op=json", server.getIp().trim(), httpPort, this.getDomain().getId(), NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        }
        return null;
    }

    @Override
    public List<Server> getServers() {
        if (this.m_config == null) {
            return Collections.emptyList();
        }
        return this.m_config.getServers();
    }

    @Override
    public int getTaggedTransactionCacheSize() {
        return 1024;
    }

    public void initialize() throws InitializationException {
        File configFile = new File(XML);
        this.initialize(configFile);
    }

    @Override
    public void initialize(File configFile) throws InitializationException {
        try {
            ClientConfig globalConfig = null;
            ClientConfig warConfig = null;
            if (configFile != null) {
                if (configFile.exists()) {
                    String xml = Files.forIO().readFrom(configFile.getCanonicalFile(), "utf-8");
                    globalConfig = DefaultSaxParser.parse(xml);
                    this.m_logger.info(String.format("Global config file(%s) found.", configFile));
                } else {
                    this.m_logger.warn(String.format("Global config file(%s) not found, IGNORED.", configFile));
                }
            }
            warConfig = this.loadConfigFromEnviroment();
            if (globalConfig != null && warConfig != null) {
                globalConfig.accept(new ClientConfigMerger(warConfig));
            }
            if (warConfig != null) {
                warConfig.accept(new ClientConfigValidator());
            }
            this.m_config = warConfig;
        }
        catch (Exception e) {
            throw new InitializationException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isAtomicMessage(MessageTree tree) {
        return this.m_atomicTreeParser.isAtomicMessage(tree);
    }

    @Override
    public boolean isBlock() {
        return this.m_block;
    }

    @Override
    public boolean isCatEnabled() {
        if (this.m_config == null) {
            return false;
        }
        return this.m_config.isEnabled();
    }

    @Override
    public boolean isDumpLocked() {
        if (this.m_config == null) {
            return false;
        }
        return this.m_config.isDumpLocked();
    }

    private ClientConfig loadConfigFromEnviroment() {
        String appName = this.loadProjectName();
        if (appName != null) {
            ClientConfig config = new ClientConfig();
            config.addDomain(new Domain(appName));
            return config;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadProjectName() {
        String appName = null;
        InputStream in = null;
        try {
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(PROPERTIES_FILE);
            if (in == null) {
                in = Cat.class.getResourceAsStream(PROPERTIES_FILE);
            }
            if (in != null) {
                Properties prop = new Properties();
                prop.load(in);
                appName = prop.getProperty("app.name");
                if (appName == null) {
                    this.m_logger.info(String.format("Can't find app.name from app.properties.", new Object[0]));
                    String string = null;
                    return string;
                }
                this.m_logger.info(String.format("Find domain name %s from app.properties.", appName));
            } else {
                this.m_logger.info(String.format("Can't find app.properties in %s", PROPERTIES_FILE));
            }
        }
        catch (Exception e) {
            this.m_logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return appName;
    }

    @Override
    public void refreshConfig() {
        String url = this.getServerConfigUrl();
        try {
            InputStream inputstream = Urls.forIO().readTimeout(2000).connectTimeout(1000).openStream(url);
            String content = Files.forIO().readFrom(inputstream, "utf-8");
            KVConfig routerConfig = (KVConfig)this.m_jsonBuilder.parse(content.trim(), KVConfig.class);
            this.m_routers = routerConfig.getValue("routers");
            this.m_sample = Double.valueOf(routerConfig.getValue("sample").trim());
            this.m_block = Boolean.valueOf(routerConfig.getValue("block").trim());
            String startTypes = routerConfig.getValue("startTransactionTypes");
            String matchTypes = routerConfig.getValue("matchTransactionTypes");
            this.m_atomicTreeParser.init(startTypes, matchTypes);
        }
        catch (Exception e) {
            this.m_logger.warn("error when connect cat server config url " + url);
        }
    }
}

