/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.client.entity;

import com.dianping.cat.configuration.client.BaseEntity;
import com.dianping.cat.configuration.client.IVisitor;
import com.dianping.cat.configuration.client.entity.Bind;
import com.dianping.cat.configuration.client.entity.Domain;
import com.dianping.cat.configuration.client.entity.Property;
import com.dianping.cat.configuration.client.entity.Server;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientConfig
extends BaseEntity<ClientConfig> {
    private String m_mode;
    private Boolean m_enabled = true;
    private Boolean m_dumpLocked;
    private List<Server> m_servers = new ArrayList<Server>();
    private Map<String, Domain> m_domains = new LinkedHashMap<String, Domain>();
    private Bind m_bind;
    private Map<String, Property> m_properties = new LinkedHashMap<String, Property>();
    private String m_baseLogDir = "target/catlog";
    private Map<String, String> m_dynamicAttributes = new LinkedHashMap<String, String>();

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitConfig(this);
    }

    public ClientConfig addDomain(Domain domain) {
        this.m_domains.put(domain.getId(), domain);
        return this;
    }

    public ClientConfig addProperty(Property property) {
        this.m_properties.put(property.getName(), property);
        return this;
    }

    public ClientConfig addServer(Server server) {
        this.m_servers.add(server);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClientConfig) {
            ClientConfig _o = (ClientConfig)obj;
            String mode = _o.getMode();
            Boolean enabled = _o.getEnabled();
            Boolean dumpLocked = _o.getDumpLocked();
            List<Server> servers = _o.getServers();
            Map<String, Domain> domains = _o.getDomains();
            Bind bind = _o.getBind();
            Map<String, Property> properties = _o.getProperties();
            String baseLogDir = _o.getBaseLogDir();
            boolean result = true;
            result &= this.m_mode == mode || this.m_mode != null && this.m_mode.equals(mode);
            result &= this.m_enabled == enabled || this.m_enabled != null && this.m_enabled.equals(enabled);
            result &= this.m_dumpLocked == dumpLocked || this.m_dumpLocked != null && this.m_dumpLocked.equals(dumpLocked);
            result &= this.m_servers == servers || this.m_servers != null && this.m_servers.equals(servers);
            result &= this.m_domains == domains || this.m_domains != null && this.m_domains.equals(domains);
            result &= this.m_bind == bind || this.m_bind != null && this.m_bind.equals(bind);
            result &= this.m_properties == properties || this.m_properties != null && this.m_properties.equals(properties);
            result &= this.m_baseLogDir == baseLogDir || this.m_baseLogDir != null && this.m_baseLogDir.equals(baseLogDir);
            return result &= this.m_dynamicAttributes.equals(_o.getDynamicAttributes());
        }
        return false;
    }

    public Domain findDomain(String id) {
        return this.m_domains.get(id);
    }

    public Property findProperty(String name) {
        return this.m_properties.get(name);
    }

    public Server findServer(String ip) {
        for (Server server : this.m_servers) {
            if (!server.getIp().equals(ip)) continue;
            return server;
        }
        return null;
    }

    public String getDynamicAttribute(String name) {
        return this.m_dynamicAttributes.get(name);
    }

    public Map<String, String> getDynamicAttributes() {
        return this.m_dynamicAttributes;
    }

    public String getBaseLogDir() {
        return this.m_baseLogDir;
    }

    public Bind getBind() {
        return this.m_bind;
    }

    public Map<String, Domain> getDomains() {
        return this.m_domains;
    }

    public Boolean getDumpLocked() {
        return this.m_dumpLocked;
    }

    public Boolean getEnabled() {
        return this.m_enabled;
    }

    public String getMode() {
        return this.m_mode;
    }

    public Map<String, Property> getProperties() {
        return this.m_properties;
    }

    public List<Server> getServers() {
        return this.m_servers;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_mode == null ? 0 : this.m_mode.hashCode());
        hash = hash * 31 + (this.m_enabled == null ? 0 : this.m_enabled.hashCode());
        hash = hash * 31 + (this.m_dumpLocked == null ? 0 : this.m_dumpLocked.hashCode());
        hash = hash * 31 + (this.m_servers == null ? 0 : this.m_servers.hashCode());
        hash = hash * 31 + (this.m_domains == null ? 0 : this.m_domains.hashCode());
        hash = hash * 31 + (this.m_bind == null ? 0 : this.m_bind.hashCode());
        hash = hash * 31 + (this.m_properties == null ? 0 : this.m_properties.hashCode());
        hash = hash * 31 + (this.m_baseLogDir == null ? 0 : this.m_baseLogDir.hashCode());
        hash = hash * 31 + this.m_dynamicAttributes.hashCode();
        return hash;
    }

    public boolean isDumpLocked() {
        return this.m_dumpLocked != null && this.m_dumpLocked != false;
    }

    public boolean isEnabled() {
        return this.m_enabled != null && this.m_enabled != false;
    }

    @Override
    public void mergeAttributes(ClientConfig other) {
        for (Map.Entry<String, String> e : other.getDynamicAttributes().entrySet()) {
            this.m_dynamicAttributes.put(e.getKey(), e.getValue());
        }
        if (other.getMode() != null) {
            this.m_mode = other.getMode();
        }
        if (other.getEnabled() != null) {
            this.m_enabled = other.getEnabled();
        }
        if (other.getDumpLocked() != null) {
            this.m_dumpLocked = other.getDumpLocked();
        }
    }

    public boolean removeDomain(String id) {
        if (this.m_domains.containsKey(id)) {
            this.m_domains.remove(id);
            return true;
        }
        return false;
    }

    public boolean removeProperty(String name) {
        if (this.m_properties.containsKey(name)) {
            this.m_properties.remove(name);
            return true;
        }
        return false;
    }

    public boolean removeServer(String ip) {
        int len = this.m_servers.size();
        for (int i = 0; i < len; ++i) {
            Server server = this.m_servers.get(i);
            if (!server.getIp().equals(ip)) continue;
            this.m_servers.remove(i);
            return true;
        }
        return false;
    }

    public void setDynamicAttribute(String name, String value) {
        this.m_dynamicAttributes.put(name, value);
    }

    public ClientConfig setBaseLogDir(String baseLogDir) {
        this.m_baseLogDir = baseLogDir;
        return this;
    }

    public ClientConfig setBind(Bind bind) {
        this.m_bind = bind;
        return this;
    }

    public ClientConfig setDumpLocked(Boolean dumpLocked) {
        this.m_dumpLocked = dumpLocked;
        return this;
    }

    public ClientConfig setEnabled(Boolean enabled) {
        this.m_enabled = enabled;
        return this;
    }

    public ClientConfig setMode(String mode) {
        this.m_mode = mode;
        return this;
    }
}

