/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.internal;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Event;
import com.dianping.cat.message.ForkedTransaction;
import com.dianping.cat.message.Heartbeat;
import com.dianping.cat.message.MessageProducer;
import com.dianping.cat.message.Metric;
import com.dianping.cat.message.TaggedTransaction;
import com.dianping.cat.message.Trace;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.DefaultEvent;
import com.dianping.cat.message.internal.DefaultForkedTransaction;
import com.dianping.cat.message.internal.DefaultHeartbeat;
import com.dianping.cat.message.internal.DefaultMessageManager;
import com.dianping.cat.message.internal.DefaultMetric;
import com.dianping.cat.message.internal.DefaultTaggedTransaction;
import com.dianping.cat.message.internal.DefaultTrace;
import com.dianping.cat.message.internal.DefaultTransaction;
import com.dianping.cat.message.internal.MessageIdFactory;
import com.dianping.cat.message.spi.MessageManager;
import com.dianping.cat.message.spi.MessageTree;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.unidal.lookup.annotation.Inject;

public class DefaultMessageProducer
implements MessageProducer {
    @Inject
    private MessageManager m_manager;
    @Inject
    private MessageIdFactory m_factory;

    public String createMessageId() {
        return this.m_factory.getNextId();
    }

    public boolean isEnabled() {
        return this.m_manager.isMessageEnabled();
    }

    public void logError(String message, Throwable cause) {
        if (Cat.getManager().isCatEnabled()) {
            if (this.shouldLog(cause)) {
                this.m_manager.getThreadLocalMessageTree().setDiscard(false);
                StringWriter writer = new StringWriter(2048);
                if (message != null) {
                    writer.write(message);
                    writer.write(32);
                }
                cause.printStackTrace(new PrintWriter(writer));
                String detailMessage = writer.toString();
                if (cause instanceof Error) {
                    this.logEvent("Error", cause.getClass().getName(), "ERROR", detailMessage);
                } else if (cause instanceof RuntimeException) {
                    this.logEvent("RuntimeException", cause.getClass().getName(), "ERROR", detailMessage);
                } else {
                    this.logEvent("Exception", cause.getClass().getName(), "ERROR", detailMessage);
                }
            }
        } else {
            cause.printStackTrace();
        }
    }

    public void logError(Throwable cause) {
        this.logError(null, cause);
    }

    public void logEvent(String type, String name) {
        this.logEvent(type, name, "0", null);
    }

    public void logEvent(String type, String name, String status, String nameValuePairs) {
        Event event = this.newEvent(type, name);
        if (nameValuePairs != null && nameValuePairs.length() > 0) {
            event.addData(nameValuePairs);
        }
        event.setStatus(status);
        event.complete();
    }

    public void logHeartbeat(String type, String name, String status, String nameValuePairs) {
        Heartbeat heartbeat = this.newHeartbeat(type, name);
        heartbeat.addData(nameValuePairs);
        heartbeat.setStatus(status);
        heartbeat.complete();
    }

    public void logMetric(String name, String status, String nameValuePairs) {
        String type = "";
        Metric metric = this.newMetric(type, name);
        if (nameValuePairs != null && nameValuePairs.length() > 0) {
            metric.addData(nameValuePairs);
        }
        metric.setStatus(status);
        metric.complete();
    }

    public void logTrace(String type, String name) {
        this.logTrace(type, name, "0", null);
    }

    public void logTrace(String type, String name, String status, String nameValuePairs) {
        if (this.m_manager.isTraceMode()) {
            Trace trace = this.newTrace(type, name);
            if (nameValuePairs != null && nameValuePairs.length() > 0) {
                trace.addData(nameValuePairs);
            }
            trace.setStatus(status);
            trace.complete();
        }
    }

    public Event newEvent(String type, String name) {
        if (!this.m_manager.hasContext()) {
            this.m_manager.setup();
        }
        DefaultEvent event = new DefaultEvent(type, name, this.m_manager);
        return event;
    }

    public Event newEvent(Transaction parent, String type, String name) {
        if (!this.m_manager.hasContext()) {
            this.m_manager.setup();
        }
        DefaultEvent event = new DefaultEvent(type, name);
        parent.addChild(event);
        return event;
    }

    public ForkedTransaction newForkedTransaction(String type, String name) {
        MessageTree tree;
        if (!this.m_manager.hasContext()) {
            this.m_manager.setup();
        }
        if ((tree = this.m_manager.getThreadLocalMessageTree()).getMessageId() == null) {
            tree.setMessageId(this.createMessageId());
        }
        DefaultForkedTransaction transaction = new DefaultForkedTransaction(type, name, this.m_manager);
        if (this.m_manager instanceof DefaultMessageManager) {
            ((DefaultMessageManager)this.m_manager).linkAsRunAway(transaction);
        }
        this.m_manager.start(transaction, true);
        return transaction;
    }

    public Heartbeat newHeartbeat(String type, String name) {
        if (!this.m_manager.hasContext()) {
            this.m_manager.setup();
        }
        DefaultHeartbeat heartbeat = new DefaultHeartbeat(type, name, this.m_manager);
        this.m_manager.getThreadLocalMessageTree().setDiscard(false);
        return heartbeat;
    }

    public Metric newMetric(String type, String name) {
        if (!this.m_manager.hasContext()) {
            this.m_manager.setup();
        }
        DefaultMetric metric = new DefaultMetric(type == null ? "" : type, name, this.m_manager);
        this.m_manager.getThreadLocalMessageTree().setDiscard(false);
        return metric;
    }

    public TaggedTransaction newTaggedTransaction(String type, String name, String tag) {
        MessageTree tree;
        if (!this.m_manager.hasContext()) {
            this.m_manager.setup();
        }
        if ((tree = this.m_manager.getThreadLocalMessageTree()).getMessageId() == null) {
            tree.setMessageId(this.createMessageId());
        }
        DefaultTaggedTransaction transaction = new DefaultTaggedTransaction(type, name, tag, this.m_manager);
        this.m_manager.start(transaction, true);
        return transaction;
    }

    public Trace newTrace(String type, String name) {
        if (!this.m_manager.hasContext()) {
            this.m_manager.setup();
        }
        DefaultTrace trace = new DefaultTrace(type, name, this.m_manager);
        return trace;
    }

    public Transaction newTransaction(String type, String name) {
        if (!this.m_manager.hasContext()) {
            this.m_manager.setup();
        }
        DefaultTransaction transaction = new DefaultTransaction(type, name, this.m_manager);
        this.m_manager.start(transaction, false);
        return transaction;
    }

    public Transaction newTransaction(Transaction parent, String type, String name) {
        if (!this.m_manager.hasContext()) {
            this.m_manager.setup();
        }
        DefaultTransaction transaction = new DefaultTransaction(type, name, this.m_manager);
        parent.addChild(transaction);
        transaction.setStandalone(false);
        return transaction;
    }

    private boolean shouldLog(Throwable e) {
        if (this.m_manager instanceof DefaultMessageManager) {
            return ((DefaultMessageManager)this.m_manager).shouldLog(e);
        }
        return true;
    }
}

