/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.io;

import com.dianping.cat.configuration.ClientConfigManager;
import com.dianping.cat.message.internal.DefaultTransaction;
import com.dianping.cat.message.internal.MessageIdFactory;
import com.dianping.cat.message.io.ChannelManager;
import com.dianping.cat.message.io.DefaultMessageQueue;
import com.dianping.cat.message.io.MessageSender;
import com.dianping.cat.message.spi.MessageCodec;
import com.dianping.cat.message.spi.MessageQueue;
import com.dianping.cat.message.spi.MessageStatistics;
import com.dianping.cat.message.spi.MessageTree;
import com.dianping.cat.message.spi.internal.DefaultMessageTree;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpSocketSender
implements Threads.Task,
MessageSender,
LogEnabled {
    public static final String ID = "tcp-socket-sender";
    public static final int SIZE = 5000;
    @Inject
    private MessageCodec m_codec;
    @Inject
    private MessageStatistics m_statistics;
    @Inject
    private ClientConfigManager m_configManager;
    @Inject
    private MessageIdFactory m_factory;
    private MessageQueue m_queue = new DefaultMessageQueue(5000);
    private MessageQueue m_atomicQueue = new DefaultMessageQueue(5000);
    private List<InetSocketAddress> m_serverAddresses;
    private ChannelManager m_channelManager;
    private Logger m_logger;
    private transient boolean m_active;
    private AtomicInteger m_errors = new AtomicInteger();
    private AtomicInteger m_sampleCount = new AtomicInteger();
    private static final int MAX_CHILD_NUMBER = 200;
    private static final int MAX_DURATION = 30000;

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public String getName() {
        return "TcpSocketSender";
    }

    @Override
    public void initialize() {
        this.m_channelManager = new ChannelManager(this.m_logger, this.m_serverAddresses, this.m_configManager, this.m_factory);
        Threads.forGroup((String)"cat").start((Runnable)((Object)this));
        Threads.forGroup((String)"cat").start((Runnable)((Object)this.m_channelManager));
        Threads.forGroup((String)"cat").start((Runnable)((Object)new MergeAtomicTask()));
    }

    private void logQueueFullInfo(MessageTree tree) {
        int count;
        if (this.m_statistics != null) {
            this.m_statistics.onOverflowed(tree);
        }
        if ((count = this.m_errors.incrementAndGet()) % 1000 == 0 || count == 1) {
            this.m_logger.error("Message queue is full in tcp socket sender! Count: " + count);
        }
        tree = null;
    }

    private MessageTree mergeTree(MessageQueue handler) {
        MessageTree tree;
        DefaultTransaction tran = new DefaultTransaction("_CatMergeTree", "_CatMergeTree", null);
        MessageTree first = handler.poll();
        tran.setStatus("0");
        tran.setCompleted(true);
        tran.setDurationInMicros(0L);
        tran.addChild(first.getMessage());
        for (int max = 200; max >= 0 && (tree = handler.poll()) != null; --max) {
            tran.addChild(tree.getMessage());
            this.m_factory.reuse(tree.getMessageId());
        }
        ((DefaultMessageTree)first).setMessage(tran);
        return first;
    }

    private void offer(MessageTree tree) {
        if (this.m_configManager.isAtomicMessage(tree)) {
            boolean result = this.m_atomicQueue.offer(tree);
            if (!result) {
                this.logQueueFullInfo(tree);
            }
        } else {
            boolean result = this.m_queue.offer(tree);
            if (!result) {
                this.logQueueFullInfo(tree);
            }
        }
    }

    public void run() {
        this.m_active = true;
        while (this.m_active) {
            ChannelFuture channel = this.m_channelManager.channel();
            if (channel != null) {
                try {
                    MessageTree tree = this.m_queue.poll();
                    if (tree == null) continue;
                    this.sendInternal(tree);
                    tree.setMessage(null);
                }
                catch (Throwable t) {
                    this.m_logger.error("Error when sending message over TCP socket!", t);
                }
                continue;
            }
            try {
                Thread.sleep(5L);
            }
            catch (Exception e) {
                this.m_active = false;
            }
        }
    }

    @Override
    public void send(MessageTree tree) {
        if (!this.m_configManager.isBlock()) {
            double sampleRatio = this.m_configManager.getSampleRatio();
            if (tree.canDiscard() && sampleRatio < 1.0) {
                if (sampleRatio > 0.0) {
                    int count = this.m_sampleCount.incrementAndGet();
                    if ((double)count % (1.0 / sampleRatio) == 0.0) {
                        this.offer(tree);
                    } else {
                        this.m_factory.reuse(tree.getMessageId());
                    }
                } else {
                    this.m_factory.reuse(tree.getMessageId());
                }
            } else {
                this.offer(tree);
            }
        } else {
            this.m_factory.reuse(tree.getMessageId());
        }
    }

    private void sendInternal(MessageTree tree) {
        ChannelFuture future = this.m_channelManager.channel();
        ByteBuf buf = PooledByteBufAllocator.DEFAULT.buffer(10240);
        this.m_codec.encode(tree, buf);
        int size = buf.readableBytes();
        Channel channel = future.channel();
        channel.writeAndFlush((Object)buf);
        if (this.m_statistics != null) {
            this.m_statistics.onBytes(size);
        }
    }

    public void setServerAddresses(List<InetSocketAddress> serverAddresses) {
        this.m_serverAddresses = serverAddresses;
    }

    private boolean shouldMerge(MessageQueue handler) {
        MessageTree tree = handler.peek();
        if (tree != null) {
            long firstTime = tree.getMessage().getTimestamp();
            if (System.currentTimeMillis() - firstTime > 30000L || handler.size() >= 200) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void shutdown() {
        this.m_active = false;
        this.m_channelManager.shutdown();
    }

    public class MergeAtomicTask
    implements Threads.Task {
        public String getName() {
            return "merge-atomic-task";
        }

        public void run() {
            while (true) {
                if (TcpSocketSender.this.shouldMerge(TcpSocketSender.this.m_atomicQueue)) {
                    MessageTree tree = TcpSocketSender.this.mergeTree(TcpSocketSender.this.m_atomicQueue);
                    boolean result = TcpSocketSender.this.m_queue.offer(tree);
                    if (result) continue;
                    TcpSocketSender.this.logQueueFullInfo(tree);
                    continue;
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }

        public void shutdown() {
        }
    }
}

