/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.spi.internal;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Event;
import com.dianping.cat.message.Heartbeat;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Metric;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.spi.MessageTree;
import com.dianping.cat.message.spi.codec.PlainTextMessageCodec;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMessageTree
implements MessageTree {
    private ByteBuf m_buf;
    private String m_domain;
    private String m_hostName;
    private String m_ipAddress;
    private Message m_message;
    private String m_messageId;
    private String m_parentMessageId;
    private String m_rootMessageId;
    private String m_sessionToken;
    private String m_threadGroupName;
    private String m_threadId;
    private String m_threadName;
    private boolean m_discard = true;
    private boolean m_processLoss = false;
    private List<Event> events = new ArrayList<Event>();
    private List<Transaction> transactions = new ArrayList<Transaction>();
    private List<Heartbeat> heartbeats = new ArrayList<Heartbeat>();
    private List<Metric> metrics = new ArrayList<Metric>();

    @Override
    public boolean canDiscard() {
        return this.m_discard;
    }

    @Override
    public MessageTree copy() {
        DefaultMessageTree tree = new DefaultMessageTree();
        tree.setDomain(this.m_domain);
        tree.setHostName(this.m_hostName);
        tree.setIpAddress(this.m_ipAddress);
        tree.setMessageId(this.m_messageId);
        tree.setParentMessageId(this.m_parentMessageId);
        tree.setRootMessageId(this.m_rootMessageId);
        tree.setSessionToken(this.m_sessionToken);
        tree.setThreadGroupName(this.m_threadGroupName);
        tree.setThreadId(this.m_threadId);
        tree.setThreadName(this.m_threadName);
        tree.setMessage(this.m_message);
        tree.setDiscard(this.m_discard);
        return tree;
    }

    public MessageTree copyForTest() {
        ByteBuf buf = null;
        try {
            PlainTextMessageCodec codec = new PlainTextMessageCodec();
            buf = ByteBufAllocator.DEFAULT.buffer();
            codec.encode(this, buf);
            buf.readInt();
            return codec.decode(buf);
        }
        catch (Exception ex) {
            Cat.logError(ex);
            return null;
        }
    }

    public ByteBuf getBuffer() {
        return this.m_buf;
    }

    @Override
    public String getDomain() {
        return this.m_domain;
    }

    @Override
    public List<Event> getEvents() {
        return this.events;
    }

    @Override
    public List<Heartbeat> getHeartbeats() {
        return this.heartbeats;
    }

    @Override
    public String getHostName() {
        return this.m_hostName;
    }

    @Override
    public String getIpAddress() {
        return this.m_ipAddress;
    }

    @Override
    public Message getMessage() {
        return this.m_message;
    }

    @Override
    public String getMessageId() {
        return this.m_messageId;
    }

    @Override
    public List<Metric> getMetrics() {
        return this.metrics;
    }

    @Override
    public String getParentMessageId() {
        return this.m_parentMessageId;
    }

    @Override
    public String getRootMessageId() {
        return this.m_rootMessageId;
    }

    @Override
    public String getSessionToken() {
        return this.m_sessionToken;
    }

    @Override
    public String getThreadGroupName() {
        return this.m_threadGroupName;
    }

    @Override
    public String getThreadId() {
        return this.m_threadId;
    }

    @Override
    public String getThreadName() {
        return this.m_threadName;
    }

    @Override
    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    @Override
    public boolean isProcessLoss() {
        return this.m_processLoss;
    }

    public void setBuffer(ByteBuf buf) {
        this.m_buf = buf;
    }

    @Override
    public void setDiscard(boolean discard) {
        this.m_discard = discard;
    }

    @Override
    public void setDomain(String domain) {
        this.m_domain = domain;
    }

    @Override
    public void setHostName(String hostName) {
        this.m_hostName = hostName;
    }

    @Override
    public void setIpAddress(String ipAddress) {
        this.m_ipAddress = ipAddress;
    }

    @Override
    public void setMessage(Message message) {
        this.m_message = message;
    }

    @Override
    public void setMessageId(String messageId) {
        if (messageId != null && messageId.length() > 0) {
            this.m_messageId = messageId;
        }
    }

    @Override
    public void setParentMessageId(String parentMessageId) {
        if (parentMessageId != null && parentMessageId.length() > 0) {
            this.m_parentMessageId = parentMessageId;
        }
    }

    @Override
    public void setProcessLoss(boolean loss) {
        this.m_processLoss = loss;
    }

    @Override
    public void setRootMessageId(String rootMessageId) {
        if (rootMessageId != null && rootMessageId.length() > 0) {
            this.m_rootMessageId = rootMessageId;
        }
    }

    @Override
    public void setSessionToken(String sessionToken) {
        this.m_sessionToken = sessionToken;
    }

    @Override
    public void setThreadGroupName(String threadGroupName) {
        this.m_threadGroupName = threadGroupName;
    }

    @Override
    public void setThreadId(String threadId) {
        this.m_threadId = threadId;
    }

    @Override
    public void setThreadName(String threadName) {
        this.m_threadName = threadName;
    }

    public String toString() {
        ByteBuf buf = null;
        String result = "";
        try {
            PlainTextMessageCodec codec = new PlainTextMessageCodec();
            buf = Unpooled.buffer();
            codec.encode(this, buf);
            buf.readInt();
            result = buf.toString(Charset.forName("utf-8"));
        }
        catch (Exception ex) {
            Cat.logError(ex);
        }
        return result;
    }
}

