/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORADataFactory;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class OracleCallableStatement
extends OraclePreparedStatement
implements oracle.jdbc.internal.OracleCallableStatement {
    public OracleCallableStatement(OracleConnection oracleConnection, String string, int n, int n2) throws SQLException {
        this(oracleConnection, string, n, n2, 1003, 1007);
    }

    public OracleCallableStatement(OracleConnection oracleConnection, String string, int n, int n2, int n3, int n4) throws SQLException {
        super(oracleConnection, string, n, n2, n3, n4);
        this.parseSqlKind();
        this.binds_out = this.connection.db_access.createDBDataSet(oracleConnection, this, n, 2);
        this.m_stmtType = 2;
    }

    public void addBatch() throws SQLException {
        if (this.binds_out.getNoOfArgs() > 0) {
            DBError.throwSqlException(90, "Stored procedure with out or inout parameters cannot be batched");
        }
        super.addBatch();
    }

    private void cleanup() {
        if (this.connection.m_stmtClearMetaData && this.binds_out != null) {
            this.binds_out.cleanup();
        }
    }

    public synchronized void clearParameters() throws SQLException {
        if (this.binds_out != null) {
            this.binds_out.clearItems();
        }
        super.clearParameters();
    }

    public void close() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OracleCallableStatement oracleCallableStatement = this;
            synchronized (oracleCallableStatement) {
                super.close();
                this.cleanup();
            }
        }
    }

    public ARRAY getARRAY(int n) throws SQLException {
        return this.getARRAYValue(false, n);
    }

    public Array getArray(int n) throws SQLException {
        return this.getARRAYValue(false, n);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        return this.getAsciiStreamValue(false, n);
    }

    public BFILE getBFILE(int n) throws SQLException {
        return this.getBFILEValue(false, n);
    }

    public BLOB getBLOB(int n) throws SQLException {
        return this.getBLOBValue(false, n);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimalValue(false, n, 0);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.getBigDecimalValue(false, n, n2);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        return this.getBinaryStreamValue(false, n);
    }

    public Blob getBlob(int n) throws SQLException {
        return this.getBLOBValue(false, n);
    }

    public boolean getBoolean(int n) throws SQLException {
        return this.getBooleanValue(false, n);
    }

    public byte getByte(int n) throws SQLException {
        return this.getByteValue(false, n);
    }

    public byte[] getBytes(int n) throws SQLException {
        return this.getBytesValue(false, n);
    }

    public CHAR getCHAR(int n) throws SQLException {
        return this.getCHARValue(false, n);
    }

    public CLOB getCLOB(int n) throws SQLException {
        return this.getCLOBValue(false, n);
    }

    public Clob getClob(int n) throws SQLException {
        return this.getCLOBValue(false, n);
    }

    public ResultSet getCursor(int n) throws SQLException {
        return this.getCursorValue(false, n);
    }

    public Object getCustomDatum(int n, CustomDatumFactory customDatumFactory) throws SQLException {
        return this.getCustomDatumValue(false, n, customDatumFactory);
    }

    public DATE getDATE(int n) throws SQLException {
        return this.getDATEValue(false, n);
    }

    public Date getDate(int n) throws SQLException {
        return this.getDateValue(false, n);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDateValue(false, n, calendar);
    }

    public double getDouble(int n) throws SQLException {
        return this.getDoubleValue(false, n);
    }

    public float getFloat(int n) throws SQLException {
        return this.getFloatValue(false, n);
    }

    public INTERVALYM getINTERVALYM(int n) throws SQLException {
        return this.getINTERVALYMValue(false, n);
    }

    public int getInt(int n) throws SQLException {
        return this.getIntValue(false, n);
    }

    public long getLong(int n) throws SQLException {
        return this.getLongValue(false, n);
    }

    public NUMBER getNUMBER(int n) throws SQLException {
        return this.getNUMBERValue(false, n);
    }

    public OPAQUE getOPAQUE(int n) throws SQLException {
        return this.getOPAQUEValue(false, n);
    }

    public Object getORAData(int n, ORADataFactory oRADataFactory) throws SQLException {
        return this.getORADataValue(false, n, oRADataFactory);
    }

    public Object getObject(int n) throws SQLException {
        return this.getObjectValue(false, n);
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.getObjectValue(false, n, map);
    }

    public Datum getOracleObject(int n) throws SQLException {
        return this.getOracleObjectValue(false, n);
    }

    public synchronized Datum[] getOraclePlsqlIndexTable(int n) throws SQLException {
        this.prepare_for_new_get(false, n);
        if (this.binds_out.getType(n - 1) != 998) {
            DBError.throwSqlException(4);
        }
        return this.binds_out.getPlsqlIndexTableItem(n - 1, this.m_currentRank);
    }

    public synchronized Object getPlsqlIndexTable(int n) throws SQLException {
        Datum[] datumArray = this.getOraclePlsqlIndexTable(n);
        int n2 = this.binds_out.getPlsqlIndexTableType(n - 1);
        Object object = null;
        switch (n2) {
            case 1: 
            case 96: 
            case 999: {
                object = new String[datumArray.length];
                break;
            }
            case 2: 
            case 6: {
                object = new BigDecimal[datumArray.length];
                break;
            }
            case 23: {
                object = new byte[datumArray.length][];
                break;
            }
            case 12: {
                object = new Timestamp[datumArray.length];
                break;
            }
            default: {
                DBError.throwSqlException(1, "Invalid column type");
            }
        }
        int n3 = 0;
        while (n3 < ((Object[])object).length) {
            object[n3] = datumArray[n3] == null ? null : datumArray[n3].toJdbc();
            ++n3;
        }
        return object;
    }

    public synchronized Object getPlsqlIndexTable(int n, Class clazz) throws SQLException {
        String string;
        Datum[] datumArray = this.getOraclePlsqlIndexTable(n);
        if (clazz == null || !clazz.isPrimitive()) {
            DBError.throwSqlException(68);
        }
        if ((string = clazz.getName()).equals("byte")) {
            byte[] byArray = new byte[datumArray.length];
            int n2 = 0;
            while (n2 < datumArray.length) {
                byArray[n2] = datumArray[n2] != null ? datumArray[n2].byteValue() : (byte)0;
                ++n2;
            }
            return byArray;
        }
        if (string.equals("char")) {
            char[] cArray = new char[datumArray.length];
            int n3 = 0;
            while (n3 < datumArray.length) {
                cArray[n3] = datumArray[n3] != null ? (char)datumArray[n3].intValue() : (char)'\u0000';
                ++n3;
            }
            return cArray;
        }
        if (string.equals("double")) {
            double[] dArray = new double[datumArray.length];
            int n4 = 0;
            while (n4 < datumArray.length) {
                dArray[n4] = datumArray[n4] != null ? datumArray[n4].doubleValue() : 0.0;
                ++n4;
            }
            return dArray;
        }
        if (string.equals("float")) {
            float[] fArray = new float[datumArray.length];
            int n5 = 0;
            while (n5 < datumArray.length) {
                fArray[n5] = datumArray[n5] != null ? datumArray[n5].floatValue() : 0.0f;
                ++n5;
            }
            return fArray;
        }
        if (string.equals("int")) {
            int[] nArray = new int[datumArray.length];
            int n6 = 0;
            while (n6 < datumArray.length) {
                nArray[n6] = datumArray[n6] != null ? datumArray[n6].intValue() : 0;
                ++n6;
            }
            return nArray;
        }
        if (string.equals("long")) {
            long[] lArray = new long[datumArray.length];
            int n7 = 0;
            while (n7 < datumArray.length) {
                lArray[n7] = datumArray[n7] != null ? datumArray[n7].longValue() : 0L;
                ++n7;
            }
            return lArray;
        }
        if (string.equals("short")) {
            short[] sArray = new short[datumArray.length];
            int n8 = 0;
            while (n8 < datumArray.length) {
                sArray[n8] = datumArray[n8] != null ? (short)datumArray[n8].intValue() : (short)0;
                ++n8;
            }
            return sArray;
        }
        if (string.equals("boolean")) {
            boolean[] blArray = new boolean[datumArray.length];
            int n9 = 0;
            while (n9 < datumArray.length) {
                blArray[n9] = datumArray[n9] != null ? datumArray[n9].booleanValue() : false;
                ++n9;
            }
            return blArray;
        }
        DBError.throwSqlException(23);
        return null;
    }

    public RAW getRAW(int n) throws SQLException {
        return this.getRAWValue(false, n);
    }

    public REF getREF(int n) throws SQLException {
        return this.getREFValue(false, n);
    }

    public ROWID getROWID(int n) throws SQLException {
        return this.getROWIDValue(false, n);
    }

    public Ref getRef(int n) throws SQLException {
        return this.getREFValue(false, n);
    }

    public STRUCT getSTRUCT(int n) throws SQLException {
        return this.getSTRUCTValue(false, n);
    }

    public short getShort(int n) throws SQLException {
        return this.getShortValue(false, n);
    }

    public String getString(int n) throws SQLException {
        return this.getStringValue(false, n);
    }

    public TIMESTAMP getTIMESTAMP(int n) throws SQLException {
        return this.getTIMESTAMPValue(false, n);
    }

    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n) throws SQLException {
        return this.getTIMESTAMPLTZValue(false, n);
    }

    public TIMESTAMPTZ getTIMESTAMPTZ(int n) throws SQLException {
        return this.getTIMESTAMPTZValue(false, n);
    }

    public Time getTime(int n) throws SQLException {
        return this.getTimeValue(false, n);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTimeValue(false, n, calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestampValue(false, n);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestampValue(false, n, calendar);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        return this.getUnicodeStreamValue(false, n);
    }

    public synchronized void registerIndexTableOutParameter(int n, int n2, int n3, int n4) throws SQLException {
        if (n2 < 0) {
            DBError.throwSqlException(68, "maxLen < 0");
        }
        int n5 = this.get_internal_type(n3);
        this.checkPlsqlIndexTableBindTypes(false, n - 1, n2, n5, n4);
        this.resetBatch();
        this.binds_out.setPlsqlIndexTableType(n - 1, n2, n4, n5);
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        this.registerOutParameter(n, n2, 0, -1);
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        this.registerOutParameter(n, n2, n3, -1);
    }

    public synchronized void registerOutParameter(int n, int n2, int n3, int n4) throws SQLException {
        this.registerOutParameterBytes(n, n2, n3, n4 * this.connection.dataSizeScale);
    }

    public synchronized void registerOutParameter(int n, int n2, String string) throws SQLException {
        if (n2 != 2002 && n2 != 2008 && n2 != 2003 && n2 != 2006 && n2 != 2007) {
            DBError.throwSqlException(12, "sqlType=" + n2);
        }
        int n3 = this.get_internal_type(n2);
        int n4 = n - 1;
        this.checkBindTypes(false, n4, n3);
        this.resetBatch();
        if (n2 == 2002 || n2 == 2006 || n2 == 2008) {
            StructDescriptor structDescriptor = StructDescriptor.createDescriptor(string, this.connection);
            this.binds_out.setType(n4, n3, structDescriptor.getOracleTypeADT());
        } else if (n2 == 2003) {
            ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor(string, this.connection);
            this.binds_out.setType(n4, n3, arrayDescriptor.getOracleTypeCOLLECTION());
        } else if (n2 == 2007) {
            OpaqueDescriptor opaqueDescriptor = OpaqueDescriptor.createDescriptor(string, this.connection);
            this.binds_out.setType(n4, n3, (OracleTypeOPAQUE)opaqueDescriptor.getPickler());
        }
    }

    public synchronized void registerOutParameterBytes(int n, int n2, int n3, int n4) throws SQLException {
        if (n2 == 2002 || n2 == 2008 || n2 == 2003 || n2 == 2006 || n2 == 2007) {
            DBError.throwSqlException(12, "sqlType=" + n2);
        }
        int n5 = n - 1;
        int n6 = this.get_internal_type(n2);
        this.checkBindTypes(false, n5, n6);
        this.resetBatch();
        int n7 = this.max_field_size;
        if (n6 == 96 || n6 == 1 || n6 == 999) {
            if (n4 != -1 && n7 < n4) {
                n7 = n4;
            }
            this.binds_out.setType(n5, 1, n2, n7, this.binds_out.getFormOfUse(n5));
        } else if (n6 == 8) {
            if (n4 != -1 && n7 < n4) {
                n7 = n4;
            }
            this.binds_out.setType(n5, 1, n2, n7, this.binds_out.getFormOfUse(n5));
        } else if (n6 == 24 || n6 == 23) {
            if (n4 != -1 && n7 < n4) {
                n7 = n4;
            }
            this.binds_out.setType(n5, 23, n2, n7, this.binds_out.getFormOfUse(n5));
        } else if (n6 == 102) {
            this.binds_out.setType(n5, 102, n2, 0, this.binds_out.getFormOfUse(n5));
            this.has_ref_cursors = true;
        } else {
            this.binds_out.setType(n5, n6, n2, n7, this.binds_out.getFormOfUse(n5));
        }
    }

    public synchronized void registerOutParameterChars(int n, int n2, int n3, int n4) throws SQLException {
        int n5 = this.connection.db_access.getNlsRatio();
        if (n2 == 1 || n2 == 12) {
            this.registerOutParameterBytes(n, n2, n3, n4 * n5);
        } else {
            this.registerOutParameterBytes(n, n2, n3, n4);
        }
    }

    private void resetBatch() {
        this.batch = 1;
    }

    public synchronized int sendBatch() throws SQLException {
        return this.valid_rows;
    }

    public synchronized void setExecuteBatch(int n) throws SQLException {
        this.resetBatch();
    }

    public synchronized void setFormOfUse(int n, short s) {
        this.binds_in.setFormOfUse(n, s);
        this.binds_out.setFormOfUse(n, s);
    }

    public boolean wasNull() throws SQLException {
        return this.wasNullValue();
    }
}

