/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.sql.Connection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.xa.client.OracleXAResource;

public class OracleXAHeteroResource
extends OracleXAResource {
    private int m_rmid = -1;

    public OracleXAHeteroResource(Connection connection) throws XAException {
        this.m_conn = connection;
        if (this.m_conn == null) {
            throw new XAException(-7);
        }
    }

    private void checkStatus(int n) throws XAException {
        if (n != 0) {
            throw new XAException(n);
        }
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        this.trace("OracleXAHeteroResource.commit(xid, bool):start");
        if (xid == null) {
            this.trace("OracleXAHeteroResource.commit(): XAER_INVAL : xid is null");
            throw new XAException(-5);
        }
        int n = bl ? 0x40000000 : 0;
        int n2 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n3 = this.do_xa_commit(n2, byArray, byArray2, this.m_rmid, n, 0);
        this.setSQLXAErrorFlag(true);
        this.trace("Return status of xa_commit is " + n3);
        this.checkStatus(n3);
        this.trace("OracleXAHeteroResource.commit(xid, bool):end");
    }

    private native int do_xa_commit(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int do_xa_end(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int do_xa_forget(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int do_xa_prepare(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int do_xa_rollback(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int do_xa_start(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    public void end(Xid xid, int n) throws XAException {
        this.trace("OracleXAHeteroResource.end(xid, int):start");
        if (xid == null) {
            this.trace("OracleXAHeteroResource.end(xid, int): XAER_INVAL : xid is null");
            throw new XAException(-5);
        }
        if (n != 0x2000000 && n != 0x4000000 && n != 0x20000000 && (n & 2) != 2) {
            this.trace("OracleXAHeteroResource.end(xid, int): XAER_INVAL; invalid flag");
            throw new XAException(-5);
        }
        int n2 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n3 = this.do_xa_end(n2, byArray, byArray2, this.m_rmid, n, 0);
        this.trace("Return status of xa_end is " + n3);
        this.setSQLXAErrorFlag(true);
        this.checkStatus(n3);
        this.trace("OracleXAHeteroResource.end(xid, int):end");
    }

    public void forget(Xid xid) throws XAException {
        this.trace("OracleXAHeteroResource.forget():start");
        if (xid == null) {
            this.trace("OracleXAHeteroResource.forget(): XAER_INVAL : xid is null");
            throw new XAException(-5);
        }
        int n = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n2 = this.do_xa_forget(n, byArray, byArray2, this.m_rmid, 0, 0);
        this.trace("Return status of xa_forget is " + n2);
        this.setSQLXAErrorFlag(true);
        this.checkStatus(n2);
        this.trace("OracleXAHeteroResource.forget():end");
    }

    synchronized int getRmid() {
        return this.m_rmid;
    }

    private static byte[] getSerializedBytes(Xid xid) {
        try {
            return Util.serializeObject(xid);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public int prepare(Xid xid) throws XAException {
        this.trace("OracleXAHeteroResource.prepare():start");
        if (xid == null) {
            this.trace("OracleXAHeteroResource.prepare(): XAER_INVAL : xid is null");
            throw new XAException(-5);
        }
        int n = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n2 = this.do_xa_prepare(n, byArray, byArray2, this.m_rmid, 0, 0);
        this.trace("Return status of xa_prepare is " + n2);
        this.setSQLXAErrorFlag(true);
        if (n2 != 0 && n2 != 3) {
            this.checkStatus(n2);
        }
        this.trace("OracleXAHeteroResource.prepare(): return value is " + n2);
        this.trace("OracleXAHeteroResource.prepare():end");
        return n2;
    }

    public void rollback(Xid xid) throws XAException {
        this.trace("OracleXAHeteroResource.rollback():start");
        if (xid == null) {
            this.trace("OracleXAHeteroResource.rollback(): XAER_INVAL : xid is null");
            throw new XAException(-5);
        }
        int n = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n2 = this.do_xa_rollback(n, byArray, byArray2, this.m_rmid, 0, 0);
        this.trace("Return status of xa_rollback is " + n2);
        this.setSQLXAErrorFlag(true);
        this.checkStatus(n2);
        this.trace("OracleXAHeteroResource.rollback():end");
    }

    synchronized void setRmid(int n) {
        this.m_rmid = n;
    }

    public void start(Xid xid, int n) throws XAException {
        this.trace("OracleXAHeteroResource.start():start");
        if (xid == null) {
            this.trace("OracleXAHeteroResource.start(): XAER_INVAL : xid is null");
            throw new XAException(-5);
        }
        if (n != 0 && n != 0x8000000 && n != 0x200000 && (n & 2) != 2) {
            this.trace("OracleXAHeteroResource.start(): XAER_INVAL; invalid flag");
            throw new XAException(-5);
        }
        int n2 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n3 = this.do_xa_start(n2, byArray, byArray2, this.m_rmid, n, 0);
        this.trace("Return status of xa_start is " + n3);
        this.setSQLXAErrorFlag(false);
        this.checkStatus(n3);
        this.trace("OracleXAHeteroResource.start():end");
    }
}

