/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.CainiaoLogisticsIntelliBatchGetResponse;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CainiaoLogisticsIntelliBatchGetRequest
extends BaseTaobaoRequest<CainiaoLogisticsIntelliBatchGetResponse> {
    private String intelliLogisticsParams;

    public void setIntelliLogisticsParams(String intelliLogisticsParams) {
        this.intelliLogisticsParams = intelliLogisticsParams;
    }

    public void setIntelliLogisticsParams(List<IntelliLogisticsParam> intelliLogisticsParams) {
        this.intelliLogisticsParams = new JSONWriter(false, true).write(intelliLogisticsParams);
    }

    public String getIntelliLogisticsParams() {
        return this.intelliLogisticsParams;
    }

    @Override
    public String getApiMethodName() {
        return "cainiao.logistics.intelli.batch.get";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("intelli_logistics_params", this.intelliLogisticsParams);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<CainiaoLogisticsIntelliBatchGetResponse> getResponseClass() {
        return CainiaoLogisticsIntelliBatchGetResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkObjectMaxListSize(this.intelliLogisticsParams, 10, "intelliLogisticsParams");
    }

    public static class IntelliLogisticsParam
    extends TaobaoObject {
        private static final long serialVersionUID = 1386532826154187288L;
        @ApiField(value="from_city")
        private String fromCity;
        @ApiField(value="from_detail_address")
        private String fromDetailAddress;
        @ApiField(value="from_district")
        private String fromDistrict;
        @ApiField(value="from_prov")
        private String fromProv;
        @ApiField(value="order_id")
        private Long orderId;
        @ApiField(value="seller_id")
        private Long sellerId;
        @ApiField(value="to_city")
        private String toCity;
        @ApiField(value="to_detail_address")
        private String toDetailAddress;
        @ApiField(value="to_district")
        private String toDistrict;
        @ApiField(value="to_prov")
        private String toProv;

        public String getFromCity() {
            return this.fromCity;
        }

        public void setFromCity(String fromCity) {
            this.fromCity = fromCity;
        }

        public String getFromDetailAddress() {
            return this.fromDetailAddress;
        }

        public void setFromDetailAddress(String fromDetailAddress) {
            this.fromDetailAddress = fromDetailAddress;
        }

        public String getFromDistrict() {
            return this.fromDistrict;
        }

        public void setFromDistrict(String fromDistrict) {
            this.fromDistrict = fromDistrict;
        }

        public String getFromProv() {
            return this.fromProv;
        }

        public void setFromProv(String fromProv) {
            this.fromProv = fromProv;
        }

        public Long getOrderId() {
            return this.orderId;
        }

        public void setOrderId(Long orderId) {
            this.orderId = orderId;
        }

        public Long getSellerId() {
            return this.sellerId;
        }

        public void setSellerId(Long sellerId) {
            this.sellerId = sellerId;
        }

        public String getToCity() {
            return this.toCity;
        }

        public void setToCity(String toCity) {
            this.toCity = toCity;
        }

        public String getToDetailAddress() {
            return this.toDetailAddress;
        }

        public void setToDetailAddress(String toDetailAddress) {
            this.toDetailAddress = toDetailAddress;
        }

        public String getToDistrict() {
            return this.toDistrict;
        }

        public void setToDistrict(String toDistrict) {
            this.toDistrict = toDistrict;
        }

        public String getToProv() {
            return this.toProv;
        }

        public void setToProv(String toProv) {
            this.toProv = toProv;
        }
    }
}

