/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TmallItemOuteridUpdateResponse;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TmallItemOuteridUpdateRequest
extends BaseTaobaoRequest<TmallItemOuteridUpdateResponse> {
    private Long itemId;
    private String outerId;
    private String skuOuters;

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getItemId() {
        return this.itemId;
    }

    public void setOuterId(String outerId) {
        this.outerId = outerId;
    }

    public String getOuterId() {
        return this.outerId;
    }

    public void setSkuOuters(String skuOuters) {
        this.skuOuters = skuOuters;
    }

    public void setSkuOuters(List<UpdateSkuOuterId> skuOuters) {
        this.skuOuters = new JSONWriter(false, true).write(skuOuters);
    }

    public String getSkuOuters() {
        return this.skuOuters;
    }

    @Override
    public String getApiMethodName() {
        return "tmall.item.outerid.update";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("item_id", (Object)this.itemId);
        txtParams.put("outer_id", this.outerId);
        txtParams.put("sku_outers", this.skuOuters);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<TmallItemOuteridUpdateResponse> getResponseClass() {
        return TmallItemOuteridUpdateResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.itemId, "itemId");
        RequestCheckUtils.checkObjectMaxListSize(this.skuOuters, 2000, "skuOuters");
    }

    public static class UpdateSkuOuterId
    extends TaobaoObject {
        private static final long serialVersionUID = 8195935437395496823L;
        @ApiField(value="outer_id")
        private String outerId;
        @ApiField(value="properties")
        private String properties;
        @ApiField(value="sku_id")
        private Long skuId;

        public String getOuterId() {
            return this.outerId;
        }

        public void setOuterId(String outerId) {
            this.outerId = outerId;
        }

        public String getProperties() {
            return this.properties;
        }

        public void setProperties(String properties) {
            this.properties = properties;
        }

        public Long getSkuId() {
            return this.skuId;
        }

        public void setSkuId(Long skuId) {
            this.skuId = skuId;
        }
    }
}

