/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TmallItemPriceUpdateResponse;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TmallItemPriceUpdateRequest
extends BaseTaobaoRequest<TmallItemPriceUpdateResponse> {
    private Long itemId;
    private String itemPrice;
    private String options;
    private String skuPrices;

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getItemId() {
        return this.itemId;
    }

    public void setItemPrice(String itemPrice) {
        this.itemPrice = itemPrice;
    }

    public String getItemPrice() {
        return this.itemPrice;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public void setOptions(UpdateItemPriceOption options) {
        this.options = new JSONWriter(false, true).write(options);
    }

    public String getOptions() {
        return this.options;
    }

    public void setSkuPrices(String skuPrices) {
        this.skuPrices = skuPrices;
    }

    public void setSkuPrices(List<UpdateSkuPrice> skuPrices) {
        this.skuPrices = new JSONWriter(false, true).write(skuPrices);
    }

    public String getSkuPrices() {
        return this.skuPrices;
    }

    @Override
    public String getApiMethodName() {
        return "tmall.item.price.update";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("item_id", (Object)this.itemId);
        txtParams.put("item_price", this.itemPrice);
        txtParams.put("options", this.options);
        txtParams.put("sku_prices", this.skuPrices);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<TmallItemPriceUpdateResponse> getResponseClass() {
        return TmallItemPriceUpdateResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.itemId, "itemId");
        RequestCheckUtils.checkObjectMaxListSize(this.skuPrices, 999999, "skuPrices");
    }

    public static class UpdateItemPriceOption
    extends TaobaoObject {
        private static final long serialVersionUID = 5498611343431237613L;
        @ApiField(value="currency_type")
        private String currencyType;
        @ApiField(value="ignore_fake_credit")
        private Boolean ignoreFakeCredit;

        public String getCurrencyType() {
            return this.currencyType;
        }

        public void setCurrencyType(String currencyType) {
            this.currencyType = currencyType;
        }

        public Boolean getIgnoreFakeCredit() {
            return this.ignoreFakeCredit;
        }

        public void setIgnoreFakeCredit(Boolean ignoreFakeCredit) {
            this.ignoreFakeCredit = ignoreFakeCredit;
        }
    }

    public static class UpdateSkuPrice
    extends TaobaoObject {
        private static final long serialVersionUID = 6662112599125756554L;
        @ApiField(value="outer_id")
        private String outerId;
        @ApiField(value="price")
        private String price;
        @ApiField(value="properties")
        private String properties;
        @ApiField(value="sku_id")
        private Long skuId;

        public String getOuterId() {
            return this.outerId;
        }

        public void setOuterId(String outerId) {
            this.outerId = outerId;
        }

        public String getPrice() {
            return this.price;
        }

        public void setPrice(String price) {
            this.price = price;
        }

        public String getProperties() {
            return this.properties;
        }

        public void setProperties(String properties) {
            this.properties = properties;
        }

        public Long getSkuId() {
            return this.skuId;
        }

        public void setSkuId(Long skuId) {
            this.skuId = skuId;
        }
    }
}

