/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TmallItemShiptimeUpdateResponse;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TmallItemShiptimeUpdateRequest
extends BaseTaobaoRequest<TmallItemShiptimeUpdateResponse> {
    private Long itemId;
    private String option;
    private String shipTime;
    private String skuShipTimes;

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getItemId() {
        return this.itemId;
    }

    public void setOption(String option) {
        this.option = option;
    }

    public void setOption(UpdateItemShipTimeOption option) {
        this.option = new JSONWriter(false, true).write(option);
    }

    public String getOption() {
        return this.option;
    }

    public void setShipTime(String shipTime) {
        this.shipTime = shipTime;
    }

    public String getShipTime() {
        return this.shipTime;
    }

    public void setSkuShipTimes(String skuShipTimes) {
        this.skuShipTimes = skuShipTimes;
    }

    public void setSkuShipTimes(List<UpdateSkuShipTime> skuShipTimes) {
        this.skuShipTimes = new JSONWriter(false, true).write(skuShipTimes);
    }

    public String getSkuShipTimes() {
        return this.skuShipTimes;
    }

    @Override
    public String getApiMethodName() {
        return "tmall.item.shiptime.update";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("item_id", (Object)this.itemId);
        txtParams.put("option", this.option);
        txtParams.put("ship_time", this.shipTime);
        txtParams.put("sku_ship_times", this.skuShipTimes);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<TmallItemShiptimeUpdateResponse> getResponseClass() {
        return TmallItemShiptimeUpdateResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.itemId, "itemId");
        RequestCheckUtils.checkObjectMaxListSize(this.skuShipTimes, 20, "skuShipTimes");
    }

    public static class UpdateItemShipTimeOption
    extends TaobaoObject {
        private static final long serialVersionUID = 8337968725695132151L;
        @ApiField(value="ship_time_type")
        private Long shipTimeType;
        @ApiField(value="update_type")
        private Long updateType;

        public Long getShipTimeType() {
            return this.shipTimeType;
        }

        public void setShipTimeType(Long shipTimeType) {
            this.shipTimeType = shipTimeType;
        }

        public Long getUpdateType() {
            return this.updateType;
        }

        public void setUpdateType(Long updateType) {
            this.updateType = updateType;
        }
    }

    public static class UpdateSkuShipTime
    extends TaobaoObject {
        private static final long serialVersionUID = 1747698572316699776L;
        @ApiField(value="outer_id")
        private String outerId;
        @ApiField(value="properties")
        private String properties;
        @ApiField(value="ship_time")
        private String shipTime;
        @ApiField(value="sku_id")
        private Long skuId;

        public String getOuterId() {
            return this.outerId;
        }

        public void setOuterId(String outerId) {
            this.outerId = outerId;
        }

        public String getProperties() {
            return this.properties;
        }

        public void setProperties(String properties) {
            this.properties = properties;
        }

        public String getShipTime() {
            return this.shipTime;
        }

        public void setShipTime(String shipTime) {
            this.shipTime = shipTime;
        }

        public Long getSkuId() {
            return this.skuId;
        }

        public void setSkuId(Long skuId) {
            this.skuId = skuId;
        }
    }
}

