/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.EticketMerchantMaConsumeResponse;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EticketMerchantMaConsumeRequest
extends BaseTaobaoRequest<EticketMerchantMaConsumeResponse> {
    private Long bizType;
    private String code;
    private Long consumeNum;
    private String isvMaList;
    private String outerId;
    private String posId;
    private String serialNum;
    private String token;

    public void setBizType(Long bizType) {
        this.bizType = bizType;
    }

    public Long getBizType() {
        return this.bizType;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public void setConsumeNum(Long consumeNum) {
        this.consumeNum = consumeNum;
    }

    public Long getConsumeNum() {
        return this.consumeNum;
    }

    public void setIsvMaList(String isvMaList) {
        this.isvMaList = isvMaList;
    }

    public void setIsvMaList(List<IsvMa> isvMaList) {
        this.isvMaList = new JSONWriter(false, true).write(isvMaList);
    }

    public String getIsvMaList() {
        return this.isvMaList;
    }

    public void setOuterId(String outerId) {
        this.outerId = outerId;
    }

    public String getOuterId() {
        return this.outerId;
    }

    public void setPosId(String posId) {
        this.posId = posId;
    }

    public String getPosId() {
        return this.posId;
    }

    public void setSerialNum(String serialNum) {
        this.serialNum = serialNum;
    }

    public String getSerialNum() {
        return this.serialNum;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    @Override
    public String getApiMethodName() {
        return "taobao.eticket.merchant.ma.consume";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("biz_type", (Object)this.bizType);
        txtParams.put("code", this.code);
        txtParams.put("consume_num", (Object)this.consumeNum);
        txtParams.put("isv_ma_list", this.isvMaList);
        txtParams.put("outer_id", this.outerId);
        txtParams.put("pos_id", this.posId);
        txtParams.put("serial_num", this.serialNum);
        txtParams.put("token", this.token);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<EticketMerchantMaConsumeResponse> getResponseClass() {
        return EticketMerchantMaConsumeResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.code, "code");
        RequestCheckUtils.checkNotEmpty(this.consumeNum, "consumeNum");
        RequestCheckUtils.checkObjectMaxListSize(this.isvMaList, 20, "isvMaList");
        RequestCheckUtils.checkNotEmpty(this.outerId, "outerId");
        RequestCheckUtils.checkNotEmpty(this.serialNum, "serialNum");
        RequestCheckUtils.checkNotEmpty(this.token, "token");
    }

    public static class IsvMa
    extends TaobaoObject {
        private static final long serialVersionUID = 1375477381591872888L;
        @ApiField(value="code")
        private String code;
        @ApiField(value="num")
        private Long num;
        @ApiField(value="qr_image")
        private String qrImage;

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public Long getNum() {
            return this.num;
        }

        public void setNum(Long num) {
            this.num = num;
        }

        public String getQrImage() {
            return this.qrImage;
        }

        public void setQrImage(String qrImage) {
            this.qrImage = qrImage;
        }
    }
}

