package com.taobao.api.domain;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;


/**
 * 包基本信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public class PackageBase extends TaobaoObject {

	private static final long serialVersionUID = 1859713627516843372L;

	/**
	 * 如果是宝贝分账，即billType为2，则必须填写宝贝分账模板 (key-value 格式, 以 ; 分隔)
	 */
	@ApiField("account_to_bill_map_str")
	private String accountToBillMapStr;

	/**
	 * 包分账类型    0：不分账，1：门店分账，2：宝贝分账，3：账号分账。
	 */
	@ApiField("bill_type")
	private Long billType;

	/**
	 * 系统自动生成，传入无效
	 */
	@ApiField("bill_version")
	private Long billVersion;

	/**
	 * 核销码商id
	 */
	@ApiField("consume_merchant_id")
	private String consumeMerchantId;

	/**
	 * 核销码商名字
	 */
	@ApiField("consume_merchant_name")
	private String consumeMerchantName;

	/**
	 * 是否关联门店：0:不关联，1:关联
	 */
	@ApiField("has_pos")
	private Long hasPos;

	/**
	 * 是否核销放行   0：不核销放行，1：核销放行
	 */
	@ApiField("is_consume_pass")
	private Long isConsumePass;

	/**
	 * 是否支持身份证核销：0:不支持，1:支持
	 */
	@ApiField("is_id_card")
	private Long isIdCard;

	/**
	 * 是否支持子账号核销：0不支持，1支持
	 */
	@ApiField("is_subaccount")
	private Long isSubaccount;

	/**
	 * 备注
	 */
	@ApiField("memo")
	private String memo;

	/**
	 * 系统自动生成，传入无效
	 */
	@ApiField("package_id")
	private Long packageId;

	/**
	 * 包名
	 */
	@ApiField("package_name")
	private String packageName;

	/**
	 * 卖家ID
	 */
	@ApiField("seller_id")
	private Long sellerId;

	/**
	 * 卖家昵称
	 */
	@ApiField("seller_nick")
	private String sellerNick;

	/**
	 * 发码方   0：淘宝，码商userId：码商，poolId：码池
	 */
	@ApiField("send_id")
	private Long sendId;

	/**
	 * 发码码商名字
	 */
	@ApiField("send_merchant_name")
	private String sendMerchantName;

	/**
	 * 发码类型 0 不发码，1 淘宝发码， 2 信任卖家发码， 3 码商发码， 4 码库发码
	 */
	@ApiField("send_type")
	private Long sendType;

	/**
	 * 系统自动生成，传入无效
	 */
	@ApiField("version")
	private Long version;


	public String getAccountToBillMapStr() {
		return this.accountToBillMapStr;
	}
	public void setAccountToBillMapStr(String accountToBillMapStr) {
		this.accountToBillMapStr = accountToBillMapStr;
	}

	public Long getBillType() {
		return this.billType;
	}
	public void setBillType(Long billType) {
		this.billType = billType;
	}

	public Long getBillVersion() {
		return this.billVersion;
	}
	public void setBillVersion(Long billVersion) {
		this.billVersion = billVersion;
	}

	public String getConsumeMerchantId() {
		return this.consumeMerchantId;
	}
	public void setConsumeMerchantId(String consumeMerchantId) {
		this.consumeMerchantId = consumeMerchantId;
	}

	public String getConsumeMerchantName() {
		return this.consumeMerchantName;
	}
	public void setConsumeMerchantName(String consumeMerchantName) {
		this.consumeMerchantName = consumeMerchantName;
	}

	public Long getHasPos() {
		return this.hasPos;
	}
	public void setHasPos(Long hasPos) {
		this.hasPos = hasPos;
	}

	public Long getIsConsumePass() {
		return this.isConsumePass;
	}
	public void setIsConsumePass(Long isConsumePass) {
		this.isConsumePass = isConsumePass;
	}

	public Long getIsIdCard() {
		return this.isIdCard;
	}
	public void setIsIdCard(Long isIdCard) {
		this.isIdCard = isIdCard;
	}

	public Long getIsSubaccount() {
		return this.isSubaccount;
	}
	public void setIsSubaccount(Long isSubaccount) {
		this.isSubaccount = isSubaccount;
	}

	public String getMemo() {
		return this.memo;
	}
	public void setMemo(String memo) {
		this.memo = memo;
	}

	public Long getPackageId() {
		return this.packageId;
	}
	public void setPackageId(Long packageId) {
		this.packageId = packageId;
	}

	public String getPackageName() {
		return this.packageName;
	}
	public void setPackageName(String packageName) {
		this.packageName = packageName;
	}

	public Long getSellerId() {
		return this.sellerId;
	}
	public void setSellerId(Long sellerId) {
		this.sellerId = sellerId;
	}

	public String getSellerNick() {
		return this.sellerNick;
	}
	public void setSellerNick(String sellerNick) {
		this.sellerNick = sellerNick;
	}

	public Long getSendId() {
		return this.sendId;
	}
	public void setSendId(Long sendId) {
		this.sendId = sendId;
	}

	public String getSendMerchantName() {
		return this.sendMerchantName;
	}
	public void setSendMerchantName(String sendMerchantName) {
		this.sendMerchantName = sendMerchantName;
	}

	public Long getSendType() {
		return this.sendType;
	}
	public void setSendType(Long sendType) {
		this.sendType = sendType;
	}

	public Long getVersion() {
		return this.version;
	}
	public void setVersion(Long version) {
		this.version = version;
	}

}
