package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaGpuAddSchemaGetResponse;

/**
 * TOP API: alibaba.gpu.add.schema.get request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.20
 */
public class AlibabaGpuAddSchemaGetRequest extends BaseTaobaoRequest<AlibabaGpuAddSchemaGetResponse> {
	
	

	/** 
	* 品牌ID
	 */
	private Long brandId;

	/** 
	* 叶子类目ID
	 */
	private Long leafCatId;

	/** 
	* 当前用户所在渠道如0代表天猫，8代表淘宝
	 */
	private Long providerId;

	public void setBrandId(Long brandId) {
		this.brandId = brandId;
	}

	public Long getBrandId() {
		return this.brandId;
	}

	public void setLeafCatId(Long leafCatId) {
		this.leafCatId = leafCatId;
	}

	public Long getLeafCatId() {
		return this.leafCatId;
	}

	public void setProviderId(Long providerId) {
		this.providerId = providerId;
	}

	public Long getProviderId() {
		return this.providerId;
	}

	public String getApiMethodName() {
		return "alibaba.gpu.add.schema.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("brand_id", this.brandId);
		txtParams.put("leaf_cat_id", this.leafCatId);
		txtParams.put("provider_id", this.providerId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaGpuAddSchemaGetResponse> getResponseClass() {
		return AlibabaGpuAddSchemaGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(leafCatId, "leafCatId");
		RequestCheckUtils.checkNotEmpty(providerId, "providerId");
	}
	

}