package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaGpuSchemaAddResponse;

/**
 * TOP API: alibaba.gpu.schema.add request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.20
 */
public class AlibabaGpuSchemaAddRequest extends BaseTaobaoRequest<AlibabaGpuSchemaAddResponse> {
	
	

	/** 
	* 品牌ID
	 */
	private Long brandId;

	/** 
	* 叶子类目ID
	 */
	private Long leafCatId;

	/** 
	* 当前用户所在渠道如0代表天猫，8代表淘宝
	 */
	private Long providerId;

	/** 
	* 根据alibaba.gpu.add.schema.get获取的规则提交上来的schema
	 */
	private String schemaXmlFields;

	public void setBrandId(Long brandId) {
		this.brandId = brandId;
	}

	public Long getBrandId() {
		return this.brandId;
	}

	public void setLeafCatId(Long leafCatId) {
		this.leafCatId = leafCatId;
	}

	public Long getLeafCatId() {
		return this.leafCatId;
	}

	public void setProviderId(Long providerId) {
		this.providerId = providerId;
	}

	public Long getProviderId() {
		return this.providerId;
	}

	public void setSchemaXmlFields(String schemaXmlFields) {
		this.schemaXmlFields = schemaXmlFields;
	}

	public String getSchemaXmlFields() {
		return this.schemaXmlFields;
	}

	public String getApiMethodName() {
		return "alibaba.gpu.schema.add";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("brand_id", this.brandId);
		txtParams.put("leaf_cat_id", this.leafCatId);
		txtParams.put("provider_id", this.providerId);
		txtParams.put("schema_xml_fields", this.schemaXmlFields);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaGpuSchemaAddResponse> getResponseClass() {
		return AlibabaGpuSchemaAddResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(leafCatId, "leafCatId");
		RequestCheckUtils.checkNotEmpty(providerId, "providerId");
		RequestCheckUtils.checkNotEmpty(schemaXmlFields, "schemaXmlFields");
	}
	

}