package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaGpuUpdateSchemaGetResponse;

/**
 * TOP API: alibaba.gpu.update.schema.get request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.20
 */
public class AlibabaGpuUpdateSchemaGetRequest extends BaseTaobaoRequest<AlibabaGpuUpdateSchemaGetResponse> {
	
	

	/** 
	* 产品ID
	 */
	private Long productId;

	/** 
	* 当前用户所在渠道如0代表天猫，8代表淘宝
	 */
	private Long providerId;

	public void setProductId(Long productId) {
		this.productId = productId;
	}

	public Long getProductId() {
		return this.productId;
	}

	public void setProviderId(Long providerId) {
		this.providerId = providerId;
	}

	public Long getProviderId() {
		return this.providerId;
	}

	public String getApiMethodName() {
		return "alibaba.gpu.update.schema.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("product_id", this.productId);
		txtParams.put("provider_id", this.providerId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaGpuUpdateSchemaGetResponse> getResponseClass() {
		return AlibabaGpuUpdateSchemaGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(productId, "productId");
		RequestCheckUtils.checkNotEmpty(providerId, "providerId");
	}
	

}