package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;
import java.util.HashMap;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.FileItem;
import com.taobao.api.TaobaoUploadRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.EticketMerchantImgUploadResponse;

/**
 * TOP API: taobao.eticket.merchant.img.upload request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class EticketMerchantImgUploadRequest extends BaseTaobaoRequest<EticketMerchantImgUploadResponse> implements TaobaoUploadRequest<EticketMerchantImgUploadResponse> {

	
	

	/** 
	* 二维码图片
	 */
	private FileItem imgBytes;

	public void setImgBytes(FileItem imgBytes) {
		this.imgBytes = imgBytes;
	}

	public FileItem getImgBytes() {
		return this.imgBytes;
	}

	public String getApiMethodName() {
		return "taobao.eticket.merchant.img.upload";
	}

	public Map<String, String> getTextParams() {
		TaobaoHashMap txtParams = new TaobaoHashMap();
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<EticketMerchantImgUploadResponse> getResponseClass() {
		return EticketMerchantImgUploadResponse.class;
	}

	public void check() throws ApiRuleException {
		
		RequestCheckUtils.checkNotEmpty(imgBytes, "imgBytes");
	}

	public Map<String, FileItem> getFileParams() {
		Map<String, FileItem> params = new HashMap<String, FileItem>();
		params.put("img_bytes", this.imgBytes);
		return params;
	}
	
	

}