package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.EticketMerchantMaAvailableResponse;

/**
 * TOP API: taobao.eticket.merchant.ma.available request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class EticketMerchantMaAvailableRequest extends BaseTaobaoRequest<EticketMerchantMaAvailableResponse> {
	
	

	/** 
	* 业务类型
	 */
	private Long bizType;

	/** 
	* 需要被核销的码
	 */
	private String code;

	/** 
	* 核销份数
	 */
	private Long consumeNum;

	/** 
	* 业务id（订单号）
	 */
	private String outerId;

	/** 
	* 机具编号
	 */
	private String posId;

	/** 
	* 核销序列号，需要保证唯一
	 */
	private String serialNum;

	/** 
	* 需要跟发码通知获取到的参数一致
	 */
	private String token;

	public void setBizType(Long bizType) {
		this.bizType = bizType;
	}

	public Long getBizType() {
		return this.bizType;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getCode() {
		return this.code;
	}

	public void setConsumeNum(Long consumeNum) {
		this.consumeNum = consumeNum;
	}

	public Long getConsumeNum() {
		return this.consumeNum;
	}

	public void setOuterId(String outerId) {
		this.outerId = outerId;
	}

	public String getOuterId() {
		return this.outerId;
	}

	public void setPosId(String posId) {
		this.posId = posId;
	}

	public String getPosId() {
		return this.posId;
	}

	public void setSerialNum(String serialNum) {
		this.serialNum = serialNum;
	}

	public String getSerialNum() {
		return this.serialNum;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getToken() {
		return this.token;
	}

	public String getApiMethodName() {
		return "taobao.eticket.merchant.ma.available";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("biz_type", this.bizType);
		txtParams.put("code", this.code);
		txtParams.put("consume_num", this.consumeNum);
		txtParams.put("outer_id", this.outerId);
		txtParams.put("pos_id", this.posId);
		txtParams.put("serial_num", this.serialNum);
		txtParams.put("token", this.token);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<EticketMerchantMaAvailableResponse> getResponseClass() {
		return EticketMerchantMaAvailableResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(code, "code");
		RequestCheckUtils.checkNotEmpty(consumeNum, "consumeNum");
		RequestCheckUtils.checkNotEmpty(outerId, "outerId");
		RequestCheckUtils.checkNotEmpty(token, "token");
	}
	

}