package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.EticketMerchantMaConsumeResponse;

/**
 * TOP API: taobao.eticket.merchant.ma.consume request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class EticketMerchantMaConsumeRequest extends BaseTaobaoRequest<EticketMerchantMaConsumeResponse> {
	
	

	/** 
	* 业务类型
	 */
	private Long bizType;

	/** 
	* 需要被核销的码
	 */
	private String code;

	/** 
	* 核销份数
	 */
	private Long consumeNum;

	/** 
	* 核销后换码的码列表
	 */
	private String isvMaList;

	/** 
	* 业务id（订单号）
	 */
	private String outerId;

	/** 
	* 机具编号
	 */
	private String posId;

	/** 
	* 核销序列号，需要保证唯一
	 */
	private String serialNum;

	/** 
	* 需要跟发码通知获取到的参数一致
	 */
	private String token;

	public void setBizType(Long bizType) {
		this.bizType = bizType;
	}

	public Long getBizType() {
		return this.bizType;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getCode() {
		return this.code;
	}

	public void setConsumeNum(Long consumeNum) {
		this.consumeNum = consumeNum;
	}

	public Long getConsumeNum() {
		return this.consumeNum;
	}

	public void setIsvMaList(String isvMaList) {
		this.isvMaList = isvMaList;
	}

	public void setIsvMaList(List<IsvMa> isvMaList) {
		this.isvMaList = new JSONWriter(false,true).write(isvMaList);
	}

	public String getIsvMaList() {
		return this.isvMaList;
	}

	public void setOuterId(String outerId) {
		this.outerId = outerId;
	}

	public String getOuterId() {
		return this.outerId;
	}

	public void setPosId(String posId) {
		this.posId = posId;
	}

	public String getPosId() {
		return this.posId;
	}

	public void setSerialNum(String serialNum) {
		this.serialNum = serialNum;
	}

	public String getSerialNum() {
		return this.serialNum;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getToken() {
		return this.token;
	}

	public String getApiMethodName() {
		return "taobao.eticket.merchant.ma.consume";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("biz_type", this.bizType);
		txtParams.put("code", this.code);
		txtParams.put("consume_num", this.consumeNum);
		txtParams.put("isv_ma_list", this.isvMaList);
		txtParams.put("outer_id", this.outerId);
		txtParams.put("pos_id", this.posId);
		txtParams.put("serial_num", this.serialNum);
		txtParams.put("token", this.token);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<EticketMerchantMaConsumeResponse> getResponseClass() {
		return EticketMerchantMaConsumeResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(code, "code");
		RequestCheckUtils.checkNotEmpty(consumeNum, "consumeNum");
		RequestCheckUtils.checkObjectMaxListSize(isvMaList, 20, "isvMaList");
		RequestCheckUtils.checkNotEmpty(outerId, "outerId");
		RequestCheckUtils.checkNotEmpty(serialNum, "serialNum");
		RequestCheckUtils.checkNotEmpty(token, "token");
	}
	
	/**
 * 核销后换码的码列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class IsvMa extends TaobaoObject {

	private static final long serialVersionUID = 2341664812891254347L;

	/**
		 * 串码码值
		 */
		@ApiField("code")
		private String code;
		/**
		 * 码的可核销份数
		 */
		@ApiField("num")
		private Long num;
		/**
		 * 二维码图片文件名。已经申请了上传二维码的码商必填，其它码商无需关心。这个值是taobao.eticket.merchant.img.upload调用后的file_name
		 */
		@ApiField("qr_image")
		private String qrImage;
	

	public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public Long getNum() {
			return this.num;
		}
		public void setNum(Long num) {
			this.num = num;
		}
		public String getQrImage() {
			return this.qrImage;
		}
		public void setQrImage(String qrImage) {
			this.qrImage = qrImage;
		}

}


}