package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.EticketMerchantMaFailsendResponse;

/**
 * TOP API: taobao.eticket.merchant.ma.failsend request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class EticketMerchantMaFailsendRequest extends BaseTaobaoRequest<EticketMerchantMaFailsendResponse> {
	
	

	/** 
	* 业务类型
	 */
	private Long bizType;

	/** 
	* 业务id（订单号）
	 */
	private String outerId;

	/** 
	* 需要与发码通知获取的值一致
	 */
	private String token;

	public void setBizType(Long bizType) {
		this.bizType = bizType;
	}

	public Long getBizType() {
		return this.bizType;
	}

	public void setOuterId(String outerId) {
		this.outerId = outerId;
	}

	public String getOuterId() {
		return this.outerId;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getToken() {
		return this.token;
	}

	public String getApiMethodName() {
		return "taobao.eticket.merchant.ma.failsend";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("biz_type", this.bizType);
		txtParams.put("outer_id", this.outerId);
		txtParams.put("token", this.token);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<EticketMerchantMaFailsendResponse> getResponseClass() {
		return EticketMerchantMaFailsendResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(outerId, "outerId");
		RequestCheckUtils.checkNotEmpty(token, "token");
	}
	

}