package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.EticketMerchantMaResendResponse;

/**
 * TOP API: taobao.eticket.merchant.ma.resend request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class EticketMerchantMaResendRequest extends BaseTaobaoRequest<EticketMerchantMaResendResponse> {
	
	

	/** 
	* 业务类型
	 */
	private Long bizType;

	/** 
	* 待重发的码列表
	 */
	private String isvMaList;

	/** 
	* 业务id（订单号）
	 */
	private String outerId;

	/** 
	* 需要跟发码通知获取到的参数一致
	 */
	private String token;

	public void setBizType(Long bizType) {
		this.bizType = bizType;
	}

	public Long getBizType() {
		return this.bizType;
	}

	public void setIsvMaList(String isvMaList) {
		this.isvMaList = isvMaList;
	}

	public void setIsvMaList(List<IsvMa> isvMaList) {
		this.isvMaList = new JSONWriter(false,true).write(isvMaList);
	}

	public String getIsvMaList() {
		return this.isvMaList;
	}

	public void setOuterId(String outerId) {
		this.outerId = outerId;
	}

	public String getOuterId() {
		return this.outerId;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getToken() {
		return this.token;
	}

	public String getApiMethodName() {
		return "taobao.eticket.merchant.ma.resend";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("biz_type", this.bizType);
		txtParams.put("isv_ma_list", this.isvMaList);
		txtParams.put("outer_id", this.outerId);
		txtParams.put("token", this.token);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<EticketMerchantMaResendResponse> getResponseClass() {
		return EticketMerchantMaResendResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(isvMaList, 200, "isvMaList");
		RequestCheckUtils.checkNotEmpty(outerId, "outerId");
		RequestCheckUtils.checkNotEmpty(token, "token");
	}
	
	/**
 * 待重发的码列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class IsvMa extends TaobaoObject {

	private static final long serialVersionUID = 8115112896851391468L;

	/**
		 * 串码码值
		 */
		@ApiField("code")
		private String code;
		/**
		 * 码的可核销份数
		 */
		@ApiField("num")
		private Long num;
		/**
		 * 二维码图片文件名。已经申请了上传二维码的码商必填，其它码商无需关心。这个值是taobao.eticket.merchant.img.upload调用后的file_name
		 */
		@ApiField("qr_image")
		private String qrImage;
	

	public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public Long getNum() {
			return this.num;
		}
		public void setNum(Long num) {
			this.num = num;
		}
		public String getQrImage() {
			return this.qrImage;
		}
		public void setQrImage(String qrImage) {
			this.qrImage = qrImage;
		}

}


}