package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.EticketMerchantMaReverseResponse;

/**
 * TOP API: taobao.eticket.merchant.ma.reverse request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class EticketMerchantMaReverseRequest extends BaseTaobaoRequest<EticketMerchantMaReverseResponse> {
	
	

	/** 
	* 业务类型
	 */
	private Long bizType;

	/** 
	* 码值
	 */
	private String code;

	/** 
	* 业务id（订单号）
	 */
	private String outerId;

	/** 
	* 机具编号，如果核销时有则必传
	 */
	private String posId;

	/** 
	* 冲正份数，需要与核销份数一致
	 */
	private Long reverseNum;

	/** 
	* 需要冲正的核销序列号
	 */
	private String serialNum;

	/** 
	* 需要跟发码通知获取到的参数一致
	 */
	private String token;

	public void setBizType(Long bizType) {
		this.bizType = bizType;
	}

	public Long getBizType() {
		return this.bizType;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getCode() {
		return this.code;
	}

	public void setOuterId(String outerId) {
		this.outerId = outerId;
	}

	public String getOuterId() {
		return this.outerId;
	}

	public void setPosId(String posId) {
		this.posId = posId;
	}

	public String getPosId() {
		return this.posId;
	}

	public void setReverseNum(Long reverseNum) {
		this.reverseNum = reverseNum;
	}

	public Long getReverseNum() {
		return this.reverseNum;
	}

	public void setSerialNum(String serialNum) {
		this.serialNum = serialNum;
	}

	public String getSerialNum() {
		return this.serialNum;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getToken() {
		return this.token;
	}

	public String getApiMethodName() {
		return "taobao.eticket.merchant.ma.reverse";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("biz_type", this.bizType);
		txtParams.put("code", this.code);
		txtParams.put("outer_id", this.outerId);
		txtParams.put("pos_id", this.posId);
		txtParams.put("reverse_num", this.reverseNum);
		txtParams.put("serial_num", this.serialNum);
		txtParams.put("token", this.token);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<EticketMerchantMaReverseResponse> getResponseClass() {
		return EticketMerchantMaReverseResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(code, "code");
		RequestCheckUtils.checkNotEmpty(outerId, "outerId");
		RequestCheckUtils.checkNotEmpty(reverseNum, "reverseNum");
		RequestCheckUtils.checkNotEmpty(serialNum, "serialNum");
		RequestCheckUtils.checkNotEmpty(token, "token");
	}
	

}