package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.EticketMerchantTbmaGetResponse;

/**
 * TOP API: taobao.eticket.merchant.tbma.get request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class EticketMerchantTbmaGetRequest extends BaseTaobaoRequest<EticketMerchantTbmaGetResponse> {
	
	

	/** 
	* 查询淘宝码请求
	 */
	private String queryTbMaCallbackReq;

	public void setQueryTbMaCallbackReq(String queryTbMaCallbackReq) {
		this.queryTbMaCallbackReq = queryTbMaCallbackReq;
	}

	public void setQueryTbMaCallbackReq(QueryTbMaCallbackReq queryTbMaCallbackReq) {
		this.queryTbMaCallbackReq = new JSONWriter(false,true).write(queryTbMaCallbackReq);
	}

	public String getQueryTbMaCallbackReq() {
		return this.queryTbMaCallbackReq;
	}

	public String getApiMethodName() {
		return "taobao.eticket.merchant.tbma.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("query_tb_ma_callback_req", this.queryTbMaCallbackReq);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<EticketMerchantTbmaGetResponse> getResponseClass() {
		return EticketMerchantTbmaGetResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 查询淘宝码请求
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class QueryTbMaCallbackReq extends TaobaoObject {

	private static final long serialVersionUID = 4164518394539367368L;

	/**
		 * 淘宝码值
		 */
		@ApiField("code")
		private String code;
	

	public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}

}


}