package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TmallChannelTradeApplyorderGetResponse;

/**
 * TOP API: tmall.channel.trade.applyorder.get request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class TmallChannelTradeApplyorderGetRequest extends BaseTaobaoRequest<TmallChannelTradeApplyorderGetResponse> {
	
	

	/** 
	* 采购申请单单号
	 */
	private String channelPurchaseApplyOrderNo;

	public void setChannelPurchaseApplyOrderNo(String channelPurchaseApplyOrderNo) {
		this.channelPurchaseApplyOrderNo = channelPurchaseApplyOrderNo;
	}

	public String getChannelPurchaseApplyOrderNo() {
		return this.channelPurchaseApplyOrderNo;
	}

	public String getApiMethodName() {
		return "tmall.channel.trade.applyorder.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("channel_purchase_apply_order_no", this.channelPurchaseApplyOrderNo);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TmallChannelTradeApplyorderGetResponse> getResponseClass() {
		return TmallChannelTradeApplyorderGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(channelPurchaseApplyOrderNo, "channelPurchaseApplyOrderNo");
	}
	

}