package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TmallChannelTradeApplyorderGetsResponse;

/**
 * TOP API: tmall.channel.trade.applyorder.gets request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class TmallChannelTradeApplyorderGetsRequest extends BaseTaobaoRequest<TmallChannelTradeApplyorderGetsResponse> {
	
	

	/** 
	* 审核状态列表
	 */
	private String auditStatusList;

	/** 
	* 渠道
	 */
	private Long channel;

	/** 
	* 申请单号
	 */
	private String channelPurchaseApplyOrderNo;

	/** 
	* 分销商nick
	 */
	private String distributorNick;

	/** 
	* 是否需要分页
	 */
	private Boolean needPagination;

	/** 
	* 查询第几页
	 */
	private Long pageNumber;

	/** 
	* 每页显示数量
	 */
	private Long pageSize;

	/** 
	* 交易类型
	 */
	private Long tradeType;

	public void setAuditStatusList(String auditStatusList) {
		this.auditStatusList = auditStatusList;
	}

	public String getAuditStatusList() {
		return this.auditStatusList;
	}

	public void setChannel(Long channel) {
		this.channel = channel;
	}

	public Long getChannel() {
		return this.channel;
	}

	public void setChannelPurchaseApplyOrderNo(String channelPurchaseApplyOrderNo) {
		this.channelPurchaseApplyOrderNo = channelPurchaseApplyOrderNo;
	}

	public String getChannelPurchaseApplyOrderNo() {
		return this.channelPurchaseApplyOrderNo;
	}

	public void setDistributorNick(String distributorNick) {
		this.distributorNick = distributorNick;
	}

	public String getDistributorNick() {
		return this.distributorNick;
	}

	public void setNeedPagination(Boolean needPagination) {
		this.needPagination = needPagination;
	}

	public Boolean getNeedPagination() {
		return this.needPagination;
	}

	public void setPageNumber(Long pageNumber) {
		this.pageNumber = pageNumber;
	}

	public Long getPageNumber() {
		return this.pageNumber;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setTradeType(Long tradeType) {
		this.tradeType = tradeType;
	}

	public Long getTradeType() {
		return this.tradeType;
	}

	public String getApiMethodName() {
		return "tmall.channel.trade.applyorder.gets";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("audit_status_list", this.auditStatusList);
		txtParams.put("channel", this.channel);
		txtParams.put("channel_purchase_apply_order_no", this.channelPurchaseApplyOrderNo);
		txtParams.put("distributor_nick", this.distributorNick);
		txtParams.put("need_pagination", this.needPagination);
		txtParams.put("page_number", this.pageNumber);
		txtParams.put("page_size", this.pageSize);
		txtParams.put("trade_type", this.tradeType);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TmallChannelTradeApplyorderGetsResponse> getResponseClass() {
		return TmallChannelTradeApplyorderGetsResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkMaxListSize(auditStatusList, 20, "auditStatusList");
	}
	

}