package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TmallChannelTradeApplyorderModifyResponse;

/**
 * TOP API: tmall.channel.trade.applyorder.modify request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class TmallChannelTradeApplyorderModifyRequest extends BaseTaobaoRequest<TmallChannelTradeApplyorderModifyResponse> {
	
	

	/** 
	* 修改关联的的宝贝信息
	 */
	private String applyOrderRelateItemModifyParamList;

	/** 
	* 采购申请单号
	 */
	private String channelPurchaseApplyOrderNo;

	public void setApplyOrderRelateItemModifyParamList(String applyOrderRelateItemModifyParamList) {
		this.applyOrderRelateItemModifyParamList = applyOrderRelateItemModifyParamList;
	}

	public void setApplyOrderRelateItemModifyParamList(List<TopChannelApplyOrderRelateItemModifyParam> applyOrderRelateItemModifyParamList) {
		this.applyOrderRelateItemModifyParamList = new JSONWriter(false,true).write(applyOrderRelateItemModifyParamList);
	}

	public String getApplyOrderRelateItemModifyParamList() {
		return this.applyOrderRelateItemModifyParamList;
	}

	public void setChannelPurchaseApplyOrderNo(String channelPurchaseApplyOrderNo) {
		this.channelPurchaseApplyOrderNo = channelPurchaseApplyOrderNo;
	}

	public String getChannelPurchaseApplyOrderNo() {
		return this.channelPurchaseApplyOrderNo;
	}

	public String getApiMethodName() {
		return "tmall.channel.trade.applyorder.modify";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("apply_order_relate_item_modify_param_list", this.applyOrderRelateItemModifyParamList);
		txtParams.put("channel_purchase_apply_order_no", this.channelPurchaseApplyOrderNo);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TmallChannelTradeApplyorderModifyResponse> getResponseClass() {
		return TmallChannelTradeApplyorderModifyResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(applyOrderRelateItemModifyParamList, 20, "applyOrderRelateItemModifyParamList");
		RequestCheckUtils.checkNotEmpty(channelPurchaseApplyOrderNo, "channelPurchaseApplyOrderNo");
	}
	
	/**
 * 修改关联的的宝贝信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopChannelApplyOrderRelateItemModifyParam extends TaobaoObject {

	private static final long serialVersionUID = 1466638254884271872L;

	/**
		 * 购买数量
		 */
		@ApiField("buy_quantity")
		private Long buyQuantity;
		/**
		 * 对应的货品ID
		 */
		@ApiField("product_id")
		private Long productId;
		/**
		 * 对应货品的skuId
		 */
		@ApiField("product_sku_id")
		private Long productSkuId;
		/**
		 * 采购价
		 */
		@ApiField("purchase_price")
		private Long purchasePrice;
	

	public Long getBuyQuantity() {
			return this.buyQuantity;
		}
		public void setBuyQuantity(Long buyQuantity) {
			this.buyQuantity = buyQuantity;
		}
		public Long getProductId() {
			return this.productId;
		}
		public void setProductId(Long productId) {
			this.productId = productId;
		}
		public Long getProductSkuId() {
			return this.productSkuId;
		}
		public void setProductSkuId(Long productSkuId) {
			this.productSkuId = productSkuId;
		}
		public Long getPurchasePrice() {
			return this.purchasePrice;
		}
		public void setPurchasePrice(Long purchasePrice) {
			this.purchasePrice = purchasePrice;
		}

}


}