package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TmallChannelTradeApplyorderRefuseResponse;

/**
 * TOP API: tmall.channel.trade.applyorder.refuse request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class TmallChannelTradeApplyorderRefuseRequest extends BaseTaobaoRequest<TmallChannelTradeApplyorderRefuseResponse> {
	
	

	/** 
	* 采购申请单号
	 */
	private String channelPurchaseApplyOrderNo;

	/** 
	* 操作描述
	 */
	private String operateDesc;

	public void setChannelPurchaseApplyOrderNo(String channelPurchaseApplyOrderNo) {
		this.channelPurchaseApplyOrderNo = channelPurchaseApplyOrderNo;
	}

	public String getChannelPurchaseApplyOrderNo() {
		return this.channelPurchaseApplyOrderNo;
	}

	public void setOperateDesc(String operateDesc) {
		this.operateDesc = operateDesc;
	}

	public String getOperateDesc() {
		return this.operateDesc;
	}

	public String getApiMethodName() {
		return "tmall.channel.trade.applyorder.refuse";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("channel_purchase_apply_order_no", this.channelPurchaseApplyOrderNo);
		txtParams.put("operate_desc", this.operateDesc);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TmallChannelTradeApplyorderRefuseResponse> getResponseClass() {
		return TmallChannelTradeApplyorderRefuseResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(channelPurchaseApplyOrderNo, "channelPurchaseApplyOrderNo");
		RequestCheckUtils.checkNotEmpty(operateDesc, "operateDesc");
	}
	

}