package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TmallChannelTradeDeliverorderGetResponse;

/**
 * TOP API: tmall.channel.trade.deliverorder.get request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class TmallChannelTradeDeliverorderGetRequest extends BaseTaobaoRequest<TmallChannelTradeDeliverorderGetResponse> {
	
	

	/** 
	* 是否包含子发货单
	 */
	private Boolean isIncludeSubOrder;

	/** 
	* 发货单号
	 */
	private Long mainDeliverOrderNo;

	public void setIsIncludeSubOrder(Boolean isIncludeSubOrder) {
		this.isIncludeSubOrder = isIncludeSubOrder;
	}

	public Boolean getIsIncludeSubOrder() {
		return this.isIncludeSubOrder;
	}

	public void setMainDeliverOrderNo(Long mainDeliverOrderNo) {
		this.mainDeliverOrderNo = mainDeliverOrderNo;
	}

	public Long getMainDeliverOrderNo() {
		return this.mainDeliverOrderNo;
	}

	public String getApiMethodName() {
		return "tmall.channel.trade.deliverorder.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("is_include_sub_order", this.isIncludeSubOrder);
		txtParams.put("main_deliver_order_no", this.mainDeliverOrderNo);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TmallChannelTradeDeliverorderGetResponse> getResponseClass() {
		return TmallChannelTradeDeliverorderGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(mainDeliverOrderNo, "mainDeliverOrderNo");
	}
	

}