package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TmallChannelTradeDeliverorderGetsResponse;

/**
 * TOP API: tmall.channel.trade.deliverorder.gets request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class TmallChannelTradeDeliverorderGetsRequest extends BaseTaobaoRequest<TmallChannelTradeDeliverorderGetsResponse> {
	
	

	/** 
	* 渠道
	 */
	private Long channel;

	/** 
	* 是否包括子发货单
	 */
	private Boolean isIncludeSubOrder;

	/** 
	* 发货单单号
	 */
	private Long mainDeliverOrderNo;

	/** 
	* 是否分页查询
	 */
	private Boolean needPagination;

	/** 
	* 发货单状态列表
	 */
	private String orderStatusList;

	/** 
	* 查询第几页
	 */
	private Long pageNumber;

	/** 
	* 每页显示数量
	 */
	private Long pageSize;

	public void setChannel(Long channel) {
		this.channel = channel;
	}

	public Long getChannel() {
		return this.channel;
	}

	public void setIsIncludeSubOrder(Boolean isIncludeSubOrder) {
		this.isIncludeSubOrder = isIncludeSubOrder;
	}

	public Boolean getIsIncludeSubOrder() {
		return this.isIncludeSubOrder;
	}

	public void setMainDeliverOrderNo(Long mainDeliverOrderNo) {
		this.mainDeliverOrderNo = mainDeliverOrderNo;
	}

	public Long getMainDeliverOrderNo() {
		return this.mainDeliverOrderNo;
	}

	public void setNeedPagination(Boolean needPagination) {
		this.needPagination = needPagination;
	}

	public Boolean getNeedPagination() {
		return this.needPagination;
	}

	public void setOrderStatusList(String orderStatusList) {
		this.orderStatusList = orderStatusList;
	}

	public String getOrderStatusList() {
		return this.orderStatusList;
	}

	public void setPageNumber(Long pageNumber) {
		this.pageNumber = pageNumber;
	}

	public Long getPageNumber() {
		return this.pageNumber;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public String getApiMethodName() {
		return "tmall.channel.trade.deliverorder.gets";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("channel", this.channel);
		txtParams.put("is_include_sub_order", this.isIncludeSubOrder);
		txtParams.put("main_deliver_order_no", this.mainDeliverOrderNo);
		txtParams.put("need_pagination", this.needPagination);
		txtParams.put("order_status_list", this.orderStatusList);
		txtParams.put("page_number", this.pageNumber);
		txtParams.put("page_size", this.pageSize);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TmallChannelTradeDeliverorderGetsResponse> getResponseClass() {
		return TmallChannelTradeDeliverorderGetsResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkMaxListSize(orderStatusList, 20, "orderStatusList");
	}
	

}