package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TmallChannelTradeDeliverorderRejectResponse;

/**
 * TOP API: tmall.channel.trade.deliverorder.reject request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class TmallChannelTradeDeliverorderRejectRequest extends BaseTaobaoRequest<TmallChannelTradeDeliverorderRejectResponse> {
	
	

	/** 
	* 发货单号
	 */
	private Long mainDeliverOrderNo;

	/** 
	* 拒绝原因
	 */
	private String operateDesc;

	public void setMainDeliverOrderNo(Long mainDeliverOrderNo) {
		this.mainDeliverOrderNo = mainDeliverOrderNo;
	}

	public Long getMainDeliverOrderNo() {
		return this.mainDeliverOrderNo;
	}

	public void setOperateDesc(String operateDesc) {
		this.operateDesc = operateDesc;
	}

	public String getOperateDesc() {
		return this.operateDesc;
	}

	public String getApiMethodName() {
		return "tmall.channel.trade.deliverorder.reject";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("main_deliver_order_no", this.mainDeliverOrderNo);
		txtParams.put("operate_desc", this.operateDesc);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TmallChannelTradeDeliverorderRejectResponse> getResponseClass() {
		return TmallChannelTradeDeliverorderRejectResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(mainDeliverOrderNo, "mainDeliverOrderNo");
		RequestCheckUtils.checkNotEmpty(operateDesc, "operateDesc");
	}
	

}