package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TmallChannelTradeDeliverorderShipResponse;

/**
 * TOP API: tmall.channel.trade.deliverorder.ship request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class TmallChannelTradeDeliverorderShipRequest extends BaseTaobaoRequest<TmallChannelTradeDeliverorderShipResponse> {
	
	

	/** 
	* 渠道
	 */
	private Long channel;

	/** 
	* 分销商Nick
	 */
	private String distributorNick;

	/** 
	* 物流运单子项
	 */
	private String logisticsOrderList;

	/** 
	* 幂等单号
	 */
	private String requestNo;

	/** 
	* 发货单子项
	 */
	private String subDeliverOrderCreateList;

	public void setChannel(Long channel) {
		this.channel = channel;
	}

	public Long getChannel() {
		return this.channel;
	}

	public void setDistributorNick(String distributorNick) {
		this.distributorNick = distributorNick;
	}

	public String getDistributorNick() {
		return this.distributorNick;
	}

	public void setLogisticsOrderList(String logisticsOrderList) {
		this.logisticsOrderList = logisticsOrderList;
	}

	public void setLogisticsOrderList(List<TopChannelLogisticsOrderDto> logisticsOrderList) {
		this.logisticsOrderList = new JSONWriter(false,true).write(logisticsOrderList);
	}

	public String getLogisticsOrderList() {
		return this.logisticsOrderList;
	}

	public void setRequestNo(String requestNo) {
		this.requestNo = requestNo;
	}

	public String getRequestNo() {
		return this.requestNo;
	}

	public void setSubDeliverOrderCreateList(String subDeliverOrderCreateList) {
		this.subDeliverOrderCreateList = subDeliverOrderCreateList;
	}

	public void setSubDeliverOrderCreateList(List<TopChannelSubDeliverOrderCreateDto> subDeliverOrderCreateList) {
		this.subDeliverOrderCreateList = new JSONWriter(false,true).write(subDeliverOrderCreateList);
	}

	public String getSubDeliverOrderCreateList() {
		return this.subDeliverOrderCreateList;
	}

	public String getApiMethodName() {
		return "tmall.channel.trade.deliverorder.ship";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("channel", this.channel);
		txtParams.put("distributor_nick", this.distributorNick);
		txtParams.put("logistics_order_list", this.logisticsOrderList);
		txtParams.put("request_no", this.requestNo);
		txtParams.put("sub_deliver_order_create_list", this.subDeliverOrderCreateList);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TmallChannelTradeDeliverorderShipResponse> getResponseClass() {
		return TmallChannelTradeDeliverorderShipResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(channel, "channel");
		RequestCheckUtils.checkNotEmpty(distributorNick, "distributorNick");
		RequestCheckUtils.checkObjectMaxListSize(logisticsOrderList, 20, "logisticsOrderList");
		RequestCheckUtils.checkNotEmpty(requestNo, "requestNo");
		RequestCheckUtils.checkObjectMaxListSize(subDeliverOrderCreateList, 20, "subDeliverOrderCreateList");
	}
	
	/**
 * 发货单子项
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopChannelSubDeliverOrderCreateDto extends TaobaoObject {

	private static final long serialVersionUID = 4177814633797133527L;

	/**
		 * 发货数量
		 */
		@ApiField("deliver_count")
		private Long deliverCount;
		/**
		 * 主采购单号
		 */
		@ApiField("main_purchase_order_no")
		private Long mainPurchaseOrderNo;
		/**
		 * 子采购单号
		 */
		@ApiField("sub_purchase_order_no")
		private Long subPurchaseOrderNo;
	

	public Long getDeliverCount() {
			return this.deliverCount;
		}
		public void setDeliverCount(Long deliverCount) {
			this.deliverCount = deliverCount;
		}
		public Long getMainPurchaseOrderNo() {
			return this.mainPurchaseOrderNo;
		}
		public void setMainPurchaseOrderNo(Long mainPurchaseOrderNo) {
			this.mainPurchaseOrderNo = mainPurchaseOrderNo;
		}
		public Long getSubPurchaseOrderNo() {
			return this.subPurchaseOrderNo;
		}
		public void setSubPurchaseOrderNo(Long subPurchaseOrderNo) {
			this.subPurchaseOrderNo = subPurchaseOrderNo;
		}

}

	/**
 * 物流运单子项
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopChannelLogisticsOrderDto extends TaobaoObject {

	private static final long serialVersionUID = 2165388334151883483L;

	/**
		 * 物流公司编号
		 */
		@ApiField("logistics_company_code")
		private String logisticsCompanyCode;
		/**
		 * 物流公司名称
		 */
		@ApiField("logistics_company_name")
		private String logisticsCompanyName;
		/**
		 * 物流单号
		 */
		@ApiField("logistics_order_no")
		private String logisticsOrderNo;
	

	public String getLogisticsCompanyCode() {
			return this.logisticsCompanyCode;
		}
		public void setLogisticsCompanyCode(String logisticsCompanyCode) {
			this.logisticsCompanyCode = logisticsCompanyCode;
		}
		public String getLogisticsCompanyName() {
			return this.logisticsCompanyName;
		}
		public void setLogisticsCompanyName(String logisticsCompanyName) {
			this.logisticsCompanyName = logisticsCompanyName;
		}
		public String getLogisticsOrderNo() {
			return this.logisticsOrderNo;
		}
		public void setLogisticsOrderNo(String logisticsOrderNo) {
			this.logisticsOrderNo = logisticsOrderNo;
		}

}


}