package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiListField;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TmallChannelTradeOrderCreateResponse;

/**
 * TOP API: tmall.channel.trade.order.create request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class TmallChannelTradeOrderCreateRequest extends BaseTaobaoRequest<TmallChannelTradeOrderCreateResponse> {
	
	

	/** 
	* 入参
	 */
	private String param0;

	public void setParam0(String param0) {
		this.param0 = param0;
	}

	public void setParam0(TopChannelPurchaseOrderCreateParam param0) {
		this.param0 = new JSONWriter(false,true).write(param0);
	}

	public String getParam0() {
		return this.param0;
	}

	public String getApiMethodName() {
		return "tmall.channel.trade.order.create";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param0", this.param0);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TmallChannelTradeOrderCreateResponse> getResponseClass() {
		return TmallChannelTradeOrderCreateResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 采购明细
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopChannelSubPurchaseOrderCreateParam extends TaobaoObject {

	private static final long serialVersionUID = 8539352724661585475L;

	/**
		 * 采购数量
		 */
		@ApiField("buy_quantity")
		private Long buyQuantity;
		/**
		 * 采购货品ID
		 */
		@ApiField("product_id")
		private Long productId;
		/**
		 * 采购货品SKU ID
		 */
		@ApiField("product_sku_id")
		private Long productSkuId;
	

	public Long getBuyQuantity() {
			return this.buyQuantity;
		}
		public void setBuyQuantity(Long buyQuantity) {
			this.buyQuantity = buyQuantity;
		}
		public Long getProductId() {
			return this.productId;
		}
		public void setProductId(Long productId) {
			this.productId = productId;
		}
		public Long getProductSkuId() {
			return this.productSkuId;
		}
		public void setProductSkuId(Long productSkuId) {
			this.productSkuId = productSkuId;
		}

}

	/**
 * 入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopChannelPurchaseOrderCreateParam extends TaobaoObject {

	private static final long serialVersionUID = 4634423654539793144L;

	/**
		 * 是否自动审批
		 */
		@ApiField("auto_audit")
		private Boolean autoAudit;
		/**
		 * 渠道编码，11-线下网批
		 */
		@ApiField("channel")
		private Long channel;
		/**
		 * 分销商淘宝数字ID，如为空，down_user_nick必须输入
		 */
		@ApiField("down_account_id")
		private Long downAccountId;
		/**
		 * 分销商用户类型，默认淘宝用户
		 */
		@ApiField("down_account_type")
		private Long downAccountType;
		/**
		 * 分销商渠道角色，默认分销终端商
		 */
		@ApiField("down_role_type")
		private Long downRoleType;
		/**
		 * 分销商昵称
		 */
		@ApiField("down_user_nick")
		private String downUserNick;
		/**
		 * 内部编码
		 */
		@ApiField("internal_code")
		private String internalCode;
		/**
		 * 采购明细
		 */
		@ApiListField("items")
		@ApiField("top_channel_sub_purchase_order_create_param")
		private List<TopChannelSubPurchaseOrderCreateParam> items;
		/**
		 * 请求编码
		 */
		@ApiField("request_no")
		private String requestNo;
	

	public Boolean getAutoAudit() {
			return this.autoAudit;
		}
		public void setAutoAudit(Boolean autoAudit) {
			this.autoAudit = autoAudit;
		}
		public Long getChannel() {
			return this.channel;
		}
		public void setChannel(Long channel) {
			this.channel = channel;
		}
		public Long getDownAccountId() {
			return this.downAccountId;
		}
		public void setDownAccountId(Long downAccountId) {
			this.downAccountId = downAccountId;
		}
		public Long getDownAccountType() {
			return this.downAccountType;
		}
		public void setDownAccountType(Long downAccountType) {
			this.downAccountType = downAccountType;
		}
		public Long getDownRoleType() {
			return this.downRoleType;
		}
		public void setDownRoleType(Long downRoleType) {
			this.downRoleType = downRoleType;
		}
		public String getDownUserNick() {
			return this.downUserNick;
		}
		public void setDownUserNick(String downUserNick) {
			this.downUserNick = downUserNick;
		}
		public String getInternalCode() {
			return this.internalCode;
		}
		public void setInternalCode(String internalCode) {
			this.internalCode = internalCode;
		}
		public List<TopChannelSubPurchaseOrderCreateParam> getItems() {
			return this.items;
		}
		public void setItems(List<TopChannelSubPurchaseOrderCreateParam> items) {
			this.items = items;
		}
		public String getRequestNo() {
			return this.requestNo;
		}
		public void setRequestNo(String requestNo) {
			this.requestNo = requestNo;
		}

}


}