package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TmallChannelTradeOrderGetResponse;

/**
 * TOP API: tmall.channel.trade.order.get request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class TmallChannelTradeOrderGetRequest extends BaseTaobaoRequest<TmallChannelTradeOrderGetResponse> {
	
	

	/** 
	* 是否包含物流信息
	 */
	private Boolean isIncludeLogistics;

	/** 
	* 是否包含主采购单（针对特殊业务）
	 */
	private Boolean isIncludeMainOrder;

	/** 
	* 是否包含子采购单
	 */
	private Boolean isIncludeSubOrder;

	/** 
	* 主采购单ID
	 */
	private Long mainPurchaseOrderNo;

	public void setIsIncludeLogistics(Boolean isIncludeLogistics) {
		this.isIncludeLogistics = isIncludeLogistics;
	}

	public Boolean getIsIncludeLogistics() {
		return this.isIncludeLogistics;
	}

	public void setIsIncludeMainOrder(Boolean isIncludeMainOrder) {
		this.isIncludeMainOrder = isIncludeMainOrder;
	}

	public Boolean getIsIncludeMainOrder() {
		return this.isIncludeMainOrder;
	}

	public void setIsIncludeSubOrder(Boolean isIncludeSubOrder) {
		this.isIncludeSubOrder = isIncludeSubOrder;
	}

	public Boolean getIsIncludeSubOrder() {
		return this.isIncludeSubOrder;
	}

	public void setMainPurchaseOrderNo(Long mainPurchaseOrderNo) {
		this.mainPurchaseOrderNo = mainPurchaseOrderNo;
	}

	public Long getMainPurchaseOrderNo() {
		return this.mainPurchaseOrderNo;
	}

	public String getApiMethodName() {
		return "tmall.channel.trade.order.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("is_include_logistics", this.isIncludeLogistics);
		txtParams.put("is_include_main_order", this.isIncludeMainOrder);
		txtParams.put("is_include_sub_order", this.isIncludeSubOrder);
		txtParams.put("main_purchase_order_no", this.mainPurchaseOrderNo);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TmallChannelTradeOrderGetResponse> getResponseClass() {
		return TmallChannelTradeOrderGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(mainPurchaseOrderNo, "mainPurchaseOrderNo");
	}
	

}