package com.taobao.api.request;

import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TmallChannelTradeOrderGetsResponse;

/**
 * TOP API: tmall.channel.trade.order.gets request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class TmallChannelTradeOrderGetsRequest extends BaseTaobaoRequest<TmallChannelTradeOrderGetsResponse> {
	
	

	/** 
	* 渠道编码
	 */
	private Long channel;

	/** 
	* 分销商Nick
	 */
	private String distributorNick;

	/** 
	* 是否包含物流信息
	 */
	private Boolean isIncludeLogistics;

	/** 
	* 是否包含主单
	 */
	private Boolean isIncludeMainOrder;

	/** 
	* 是否包含子单
	 */
	private Boolean isIncludeSubOrder;

	/** 
	* 主采购单号
	 */
	private Long mainPurchaseOrderNo;

	/** 
	* 是否分页查询
	 */
	private Boolean needPagination;

	/** 
	* 查询第几页
	 */
	private Long pageNumber;

	/** 
	* 每页显示数量
	 */
	private Long pageSize;

	/** 
	* 1-代销；2-经销
	 */
	private Long tradeType;

	public void setChannel(Long channel) {
		this.channel = channel;
	}

	public Long getChannel() {
		return this.channel;
	}

	public void setDistributorNick(String distributorNick) {
		this.distributorNick = distributorNick;
	}

	public String getDistributorNick() {
		return this.distributorNick;
	}

	public void setIsIncludeLogistics(Boolean isIncludeLogistics) {
		this.isIncludeLogistics = isIncludeLogistics;
	}

	public Boolean getIsIncludeLogistics() {
		return this.isIncludeLogistics;
	}

	public void setIsIncludeMainOrder(Boolean isIncludeMainOrder) {
		this.isIncludeMainOrder = isIncludeMainOrder;
	}

	public Boolean getIsIncludeMainOrder() {
		return this.isIncludeMainOrder;
	}

	public void setIsIncludeSubOrder(Boolean isIncludeSubOrder) {
		this.isIncludeSubOrder = isIncludeSubOrder;
	}

	public Boolean getIsIncludeSubOrder() {
		return this.isIncludeSubOrder;
	}

	public void setMainPurchaseOrderNo(Long mainPurchaseOrderNo) {
		this.mainPurchaseOrderNo = mainPurchaseOrderNo;
	}

	public Long getMainPurchaseOrderNo() {
		return this.mainPurchaseOrderNo;
	}

	public void setNeedPagination(Boolean needPagination) {
		this.needPagination = needPagination;
	}

	public Boolean getNeedPagination() {
		return this.needPagination;
	}

	public void setPageNumber(Long pageNumber) {
		this.pageNumber = pageNumber;
	}

	public Long getPageNumber() {
		return this.pageNumber;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setTradeType(Long tradeType) {
		this.tradeType = tradeType;
	}

	public Long getTradeType() {
		return this.tradeType;
	}

	public String getApiMethodName() {
		return "tmall.channel.trade.order.gets";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("channel", this.channel);
		txtParams.put("distributor_nick", this.distributorNick);
		txtParams.put("is_include_logistics", this.isIncludeLogistics);
		txtParams.put("is_include_main_order", this.isIncludeMainOrder);
		txtParams.put("is_include_sub_order", this.isIncludeSubOrder);
		txtParams.put("main_purchase_order_no", this.mainPurchaseOrderNo);
		txtParams.put("need_pagination", this.needPagination);
		txtParams.put("page_number", this.pageNumber);
		txtParams.put("page_size", this.pageSize);
		txtParams.put("trade_type", this.tradeType);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TmallChannelTradeOrderGetsResponse> getResponseClass() {
		return TmallChannelTradeOrderGetsResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}