package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TmallChannelTradeOrderStopResponse;

/**
 * TOP API: tmall.channel.trade.order.stop request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class TmallChannelTradeOrderStopRequest extends BaseTaobaoRequest<TmallChannelTradeOrderStopResponse> {
	
	

	/** 
	* 主采购单号
	 */
	private Long mainPurchaseOrderNo;

	/** 
	* 幂等单号
	 */
	private String requestNo;

	public void setMainPurchaseOrderNo(Long mainPurchaseOrderNo) {
		this.mainPurchaseOrderNo = mainPurchaseOrderNo;
	}

	public Long getMainPurchaseOrderNo() {
		return this.mainPurchaseOrderNo;
	}

	public void setRequestNo(String requestNo) {
		this.requestNo = requestNo;
	}

	public String getRequestNo() {
		return this.requestNo;
	}

	public String getApiMethodName() {
		return "tmall.channel.trade.order.stop";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("main_purchase_order_no", this.mainPurchaseOrderNo);
		txtParams.put("request_no", this.requestNo);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TmallChannelTradeOrderStopResponse> getResponseClass() {
		return TmallChannelTradeOrderStopResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(mainPurchaseOrderNo, "mainPurchaseOrderNo");
		RequestCheckUtils.checkNotEmpty(requestNo, "requestNo");
	}
	

}