package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.VmarketEticketAuthBeforeconsumeResponse;

/**
 * TOP API: taobao.vmarket.eticket.auth.beforeconsume request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class VmarketEticketAuthBeforeconsumeRequest extends BaseTaobaoRequest<VmarketEticketAuthBeforeconsumeResponse> {
	
	

	/** 
	* 核销方的ID，如果是普通码商必须传入机具ID,如果是私有码商家（即原有的信任商家）可默认传入私有码商ID
	 */
	private String operatorid;

	/** 
	* 网点ID,网点授权核销时，必须传入；其他核销方式可不传
	 */
	private String storeid;

	/** 
	* 核销的码，只支持单个码，多个码核销需要多次调用
	 */
	private String verifyCode;

	public void setOperatorid(String operatorid) {
		this.operatorid = operatorid;
	}

	public String getOperatorid() {
		return this.operatorid;
	}

	public void setStoreid(String storeid) {
		this.storeid = storeid;
	}

	public String getStoreid() {
		return this.storeid;
	}

	public void setVerifyCode(String verifyCode) {
		this.verifyCode = verifyCode;
	}

	public String getVerifyCode() {
		return this.verifyCode;
	}

	public String getApiMethodName() {
		return "taobao.vmarket.eticket.auth.beforeconsume";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("operatorid", this.operatorid);
		txtParams.put("storeid", this.storeid);
		txtParams.put("verify_code", this.verifyCode);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<VmarketEticketAuthBeforeconsumeResponse> getResponseClass() {
		return VmarketEticketAuthBeforeconsumeResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(operatorid, "operatorid");
		RequestCheckUtils.checkNotEmpty(verifyCode, "verifyCode");
	}
	

}