package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.VmarketEticketAuthConsumeResponse;

/**
 * TOP API: taobao.vmarket.eticket.auth.consume request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class VmarketEticketAuthConsumeRequest extends BaseTaobaoRequest<VmarketEticketAuthConsumeResponse> {
	
	

	/** 
	* 核销份数
	 */
	private Long consumeNum;

	/** 
	* 核销方的ID，如果是普通码商必须传入机具ID,如果是私有码商家（即原有的信任商家）可默认传入私有码商ID
	 */
	private String operatorid;

	/** 
	* 自定义核销流水号，需要小于等于100个字符(a-zA-Z0-9_)
	 */
	private String serialNum;

	/** 
	* 网点ID,网点授权核销时，必须传入；其他核销方式可不传
	 */
	private String storeid;

	/** 
	* 核销的码，只支持单个码，多个码核销需要多次调用
	 */
	private String verifyCode;

	public void setConsumeNum(Long consumeNum) {
		this.consumeNum = consumeNum;
	}

	public Long getConsumeNum() {
		return this.consumeNum;
	}

	public void setOperatorid(String operatorid) {
		this.operatorid = operatorid;
	}

	public String getOperatorid() {
		return this.operatorid;
	}

	public void setSerialNum(String serialNum) {
		this.serialNum = serialNum;
	}

	public String getSerialNum() {
		return this.serialNum;
	}

	public void setStoreid(String storeid) {
		this.storeid = storeid;
	}

	public String getStoreid() {
		return this.storeid;
	}

	public void setVerifyCode(String verifyCode) {
		this.verifyCode = verifyCode;
	}

	public String getVerifyCode() {
		return this.verifyCode;
	}

	public String getApiMethodName() {
		return "taobao.vmarket.eticket.auth.consume";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("consume_num", this.consumeNum);
		txtParams.put("operatorid", this.operatorid);
		txtParams.put("serial_num", this.serialNum);
		txtParams.put("storeid", this.storeid);
		txtParams.put("verify_code", this.verifyCode);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<VmarketEticketAuthConsumeResponse> getResponseClass() {
		return VmarketEticketAuthConsumeResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(consumeNum, "consumeNum");
		RequestCheckUtils.checkNotEmpty(operatorid, "operatorid");
		RequestCheckUtils.checkNotEmpty(serialNum, "serialNum");
		RequestCheckUtils.checkNotEmpty(verifyCode, "verifyCode");
	}
	

}