package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.VmarketEticketBeforeconsumeResponse;

/**
 * TOP API: taobao.vmarket.eticket.beforeconsume request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class VmarketEticketBeforeconsumeRequest extends BaseTaobaoRequest<VmarketEticketBeforeconsumeResponse> {
	
	

	/** 
	* 码商ID,是码商的话必须传递,如果是信任卖家不需要传
	 */
	private Long codemerchantId;

	/** 
	* 手机号码后四位,没有特殊说明请不要传
	 */
	private String mobile;

	/** 
	* 需要验码的电子凭证订单ID
	 */
	private Long orderId;

	/** 
	* 操作员身份ID，如果是码商必须传,如果是信任卖家不需要传
	 */
	private String posid;

	/** 
	* 安全验证token，需要和发码通知中的token一致
	 */
	private String token;

	/** 
	* 需要验的码
	 */
	private String verifyCode;

	public void setCodemerchantId(Long codemerchantId) {
		this.codemerchantId = codemerchantId;
	}

	public Long getCodemerchantId() {
		return this.codemerchantId;
	}

	public void setMobile(String mobile) {
		this.mobile = mobile;
	}

	public String getMobile() {
		return this.mobile;
	}

	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}

	public Long getOrderId() {
		return this.orderId;
	}

	public void setPosid(String posid) {
		this.posid = posid;
	}

	public String getPosid() {
		return this.posid;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getToken() {
		return this.token;
	}

	public void setVerifyCode(String verifyCode) {
		this.verifyCode = verifyCode;
	}

	public String getVerifyCode() {
		return this.verifyCode;
	}

	public String getApiMethodName() {
		return "taobao.vmarket.eticket.beforeconsume";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("codemerchant_id", this.codemerchantId);
		txtParams.put("mobile", this.mobile);
		txtParams.put("order_id", this.orderId);
		txtParams.put("posid", this.posid);
		txtParams.put("token", this.token);
		txtParams.put("verify_code", this.verifyCode);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<VmarketEticketBeforeconsumeResponse> getResponseClass() {
		return VmarketEticketBeforeconsumeResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(orderId, "orderId");
		RequestCheckUtils.checkNotEmpty(token, "token");
		RequestCheckUtils.checkNotEmpty(verifyCode, "verifyCode");
	}
	

}