package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.VmarketEticketCardConsumecardResponse;

/**
 * TOP API: taobao.vmarket.eticket.card.consumecard request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class VmarketEticketCardConsumecardRequest extends BaseTaobaoRequest<VmarketEticketCardConsumecardResponse> {
	
	

	/** 
	* 买家昵称
	 */
	private String buyerNick;

	/** 
	* 卡号
	 */
	private String cardId;

	/** 
	* 卡内等级
	 */
	private Long cardLevel;

	/** 
	* 核销code
	 */
	private String consumeCode;

	/** 
	* 核销流水号，外部ISV全局唯一
	 */
	private String consumeSerialNum;

	/** 
	* 核销金额，精确到分，例如1.99元=199
	 */
	private Long consumeValue;

	/** 
	* 操作人id
	 */
	private Long operatorId;

	/** 
	* 核销原因
	 */
	private String reason;

	/** 
	* 门店id
	 */
	private Long storeId;

	/** 
	* 安全token
	 */
	private String token;

	public void setBuyerNick(String buyerNick) {
		this.buyerNick = buyerNick;
	}

	public String getBuyerNick() {
		return this.buyerNick;
	}

	public void setCardId(String cardId) {
		this.cardId = cardId;
	}

	public String getCardId() {
		return this.cardId;
	}

	public void setCardLevel(Long cardLevel) {
		this.cardLevel = cardLevel;
	}

	public Long getCardLevel() {
		return this.cardLevel;
	}

	public void setConsumeCode(String consumeCode) {
		this.consumeCode = consumeCode;
	}

	public String getConsumeCode() {
		return this.consumeCode;
	}

	public void setConsumeSerialNum(String consumeSerialNum) {
		this.consumeSerialNum = consumeSerialNum;
	}

	public String getConsumeSerialNum() {
		return this.consumeSerialNum;
	}

	public void setConsumeValue(Long consumeValue) {
		this.consumeValue = consumeValue;
	}

	public Long getConsumeValue() {
		return this.consumeValue;
	}

	public void setOperatorId(Long operatorId) {
		this.operatorId = operatorId;
	}

	public Long getOperatorId() {
		return this.operatorId;
	}

	public void setReason(String reason) {
		this.reason = reason;
	}

	public String getReason() {
		return this.reason;
	}

	public void setStoreId(Long storeId) {
		this.storeId = storeId;
	}

	public Long getStoreId() {
		return this.storeId;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getToken() {
		return this.token;
	}

	public String getApiMethodName() {
		return "taobao.vmarket.eticket.card.consumecard";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("buyer_nick", this.buyerNick);
		txtParams.put("card_id", this.cardId);
		txtParams.put("card_level", this.cardLevel);
		txtParams.put("consume_code", this.consumeCode);
		txtParams.put("consume_serial_num", this.consumeSerialNum);
		txtParams.put("consume_value", this.consumeValue);
		txtParams.put("operator_id", this.operatorId);
		txtParams.put("reason", this.reason);
		txtParams.put("store_id", this.storeId);
		txtParams.put("token", this.token);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<VmarketEticketCardConsumecardResponse> getResponseClass() {
		return VmarketEticketCardConsumecardResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(buyerNick, "buyerNick");
		RequestCheckUtils.checkNotEmpty(cardId, "cardId");
		RequestCheckUtils.checkNotEmpty(cardLevel, "cardLevel");
		RequestCheckUtils.checkNotEmpty(consumeSerialNum, "consumeSerialNum");
		RequestCheckUtils.checkNotEmpty(consumeValue, "consumeValue");
		RequestCheckUtils.checkNotEmpty(operatorId, "operatorId");
		RequestCheckUtils.checkNotEmpty(reason, "reason");
		RequestCheckUtils.checkNotEmpty(token, "token");
	}
	

}