package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.VmarketEticketCodesGetResponse;

/**
 * TOP API: taobao.vmarket.eticket.codes.get request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class VmarketEticketCodesGetRequest extends BaseTaobaoRequest<VmarketEticketCodesGetResponse> {
	
	

	/** 
	* 码商ID
	 */
	private Long codemerchantId;

	/** 
	* 订单号
	 */
	private Long orderId;

	public void setCodemerchantId(Long codemerchantId) {
		this.codemerchantId = codemerchantId;
	}

	public Long getCodemerchantId() {
		return this.codemerchantId;
	}

	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}

	public Long getOrderId() {
		return this.orderId;
	}

	public String getApiMethodName() {
		return "taobao.vmarket.eticket.codes.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("codemerchant_id", this.codemerchantId);
		txtParams.put("order_id", this.orderId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<VmarketEticketCodesGetResponse> getResponseClass() {
		return VmarketEticketCodesGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(orderId, "orderId");
	}
	

}