package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.VmarketEticketConsumeResponse;

/**
 * TOP API: taobao.vmarket.eticket.consume request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class VmarketEticketConsumeRequest extends BaseTaobaoRequest<VmarketEticketConsumeResponse> {
	
	

	/** 
	* 码商ID,是码商的话必须传递,如果是信任卖家不需要传
	 */
	private Long codemerchantId;

	/** 
	* 核销份数
	 */
	private Long consumeNum;

	/** 
	* 手机后四位(没有特殊说明请不要传该参数)
	 */
	private String mobile;

	/** 
	* 核销后需要重新生成的码，如果不需要重新生成码，不要传该参数
	 */
	private String newCode;

	/** 
	* 进行验码的电子凭证订单的订单ID
	 */
	private Long orderId;

	/** 
	* 机具ID(此参数信任卖家可不传递，码商必须传递)
	 */
	private String posid;

	/** 
	* 不需要上传二维码图片或者核销后不需重新生成码码商请不要传，需要传入二维码的码商请先调用taobao.vmarket.eticket.qrcode.upload接口，将返回的img_filename文件名称作为参数（如果二维码不变的话，也可将将发码时传入二维码文件名作为参数传入），文件名与参数new_code必须相互对应。
	 */
	private String qrImages;

	/** 
	* 自定义核销流水号，如果核销调用失败，可以用该核销流水号进行冲正操作，需要小于等于100个字符(a-zA-Z0-9_)；每次核销都是唯一的流水号
	 */
	private String serialNum;

	/** 
	* 安全验证token,需要和发码通知中的token一致
	 */
	private String token;

	/** 
	* 核销的码，只支持单个码，多个码核销需要多次调用
	 */
	private String verifyCode;

	public void setCodemerchantId(Long codemerchantId) {
		this.codemerchantId = codemerchantId;
	}

	public Long getCodemerchantId() {
		return this.codemerchantId;
	}

	public void setConsumeNum(Long consumeNum) {
		this.consumeNum = consumeNum;
	}

	public Long getConsumeNum() {
		return this.consumeNum;
	}

	public void setMobile(String mobile) {
		this.mobile = mobile;
	}

	public String getMobile() {
		return this.mobile;
	}

	public void setNewCode(String newCode) {
		this.newCode = newCode;
	}

	public String getNewCode() {
		return this.newCode;
	}

	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}

	public Long getOrderId() {
		return this.orderId;
	}

	public void setPosid(String posid) {
		this.posid = posid;
	}

	public String getPosid() {
		return this.posid;
	}

	public void setQrImages(String qrImages) {
		this.qrImages = qrImages;
	}

	public String getQrImages() {
		return this.qrImages;
	}

	public void setSerialNum(String serialNum) {
		this.serialNum = serialNum;
	}

	public String getSerialNum() {
		return this.serialNum;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getToken() {
		return this.token;
	}

	public void setVerifyCode(String verifyCode) {
		this.verifyCode = verifyCode;
	}

	public String getVerifyCode() {
		return this.verifyCode;
	}

	public String getApiMethodName() {
		return "taobao.vmarket.eticket.consume";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("codemerchant_id", this.codemerchantId);
		txtParams.put("consume_num", this.consumeNum);
		txtParams.put("mobile", this.mobile);
		txtParams.put("new_code", this.newCode);
		txtParams.put("order_id", this.orderId);
		txtParams.put("posid", this.posid);
		txtParams.put("qr_images", this.qrImages);
		txtParams.put("serial_num", this.serialNum);
		txtParams.put("token", this.token);
		txtParams.put("verify_code", this.verifyCode);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<VmarketEticketConsumeResponse> getResponseClass() {
		return VmarketEticketConsumeResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(consumeNum, "consumeNum");
		RequestCheckUtils.checkNotEmpty(orderId, "orderId");
		RequestCheckUtils.checkNotEmpty(token, "token");
		RequestCheckUtils.checkNotEmpty(verifyCode, "verifyCode");
	}
	

}