package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.VmarketEticketFailsendResponse;

/**
 * TOP API: taobao.vmarket.eticket.failsend request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class VmarketEticketFailsendRequest extends BaseTaobaoRequest<VmarketEticketFailsendResponse> {
	
	

	/** 
	* 错误码
	 */
	private Long errorCode;

	/** 
	* 错误信息
	 */
	private String errorMsg;

	/** 
	* 订单号
	 */
	private Long orderId;

	/** 
	* 发码通知时的token
	 */
	private String token;

	public void setErrorCode(Long errorCode) {
		this.errorCode = errorCode;
	}

	public Long getErrorCode() {
		return this.errorCode;
	}

	public void setErrorMsg(String errorMsg) {
		this.errorMsg = errorMsg;
	}

	public String getErrorMsg() {
		return this.errorMsg;
	}

	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}

	public Long getOrderId() {
		return this.orderId;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getToken() {
		return this.token;
	}

	public String getApiMethodName() {
		return "taobao.vmarket.eticket.failsend";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("error_code", this.errorCode);
		txtParams.put("error_msg", this.errorMsg);
		txtParams.put("order_id", this.orderId);
		txtParams.put("token", this.token);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<VmarketEticketFailsendResponse> getResponseClass() {
		return VmarketEticketFailsendResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(errorCode, "errorCode");
		RequestCheckUtils.checkNotEmpty(orderId, "orderId");
	}
	

}