package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.VmarketEticketFlowConsumeResponse;

/**
 * TOP API: taobao.vmarket.eticket.flow.consume request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class VmarketEticketFlowConsumeRequest extends BaseTaobaoRequest<VmarketEticketFlowConsumeResponse> {
	
	

	/** 
	* 淘宝业务提供的业务类型值，请联系相关业务运营取得
	 */
	private Long bizType;

	/** 
	* 凭证码
	 */
	private String code;

	/** 
	* 核销操作人
	 */
	private String operator;

	/** 
	* 业务单号
	 */
	private String outerId;

	public void setBizType(Long bizType) {
		this.bizType = bizType;
	}

	public Long getBizType() {
		return this.bizType;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getCode() {
		return this.code;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}

	public String getOperator() {
		return this.operator;
	}

	public void setOuterId(String outerId) {
		this.outerId = outerId;
	}

	public String getOuterId() {
		return this.outerId;
	}

	public String getApiMethodName() {
		return "taobao.vmarket.eticket.flow.consume";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("biz_type", this.bizType);
		txtParams.put("code", this.code);
		txtParams.put("operator", this.operator);
		txtParams.put("outer_id", this.outerId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<VmarketEticketFlowConsumeResponse> getResponseClass() {
		return VmarketEticketFlowConsumeResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(bizType, "bizType");
		RequestCheckUtils.checkNotEmpty(code, "code");
		RequestCheckUtils.checkNotEmpty(outerId, "outerId");
	}
	

}