package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.VmarketEticketFlowResendResponse;

/**
 * TOP API: taobao.vmarket.eticket.flow.resend request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class VmarketEticketFlowResendRequest extends BaseTaobaoRequest<VmarketEticketFlowResendResponse> {
	
	

	/** 
	* 业务类型值，可联系淘宝业务运营取得具体值
	 */
	private Long bizType;

	/** 
	* 业务单号
	 */
	private String outerId;

	public void setBizType(Long bizType) {
		this.bizType = bizType;
	}

	public Long getBizType() {
		return this.bizType;
	}

	public void setOuterId(String outerId) {
		this.outerId = outerId;
	}

	public String getOuterId() {
		return this.outerId;
	}

	public String getApiMethodName() {
		return "taobao.vmarket.eticket.flow.resend";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("biz_type", this.bizType);
		txtParams.put("outer_id", this.outerId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<VmarketEticketFlowResendResponse> getResponseClass() {
		return VmarketEticketFlowResendResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(bizType, "bizType");
		RequestCheckUtils.checkNotEmpty(outerId, "outerId");
	}
	

}