package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.VmarketEticketManageNotifyResponse;

/**
 * TOP API: taobao.vmarket.eticket.manage.notify request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class VmarketEticketManageNotifyRequest extends BaseTaobaoRequest<VmarketEticketManageNotifyResponse> {
	
	

	/** 
	* 码商ID，如果是码商，必须传，如果是信任卖家，不需要传
	 */
	private Long codemerchantId;

	/** 
	* 需要调用的通知方法，目前仅支持是send（发码）或resend（重新发码）
	 */
	private String notifyMethod;

	/** 
	* 订单编号
	 */
	private Long orderId;

	public void setCodemerchantId(Long codemerchantId) {
		this.codemerchantId = codemerchantId;
	}

	public Long getCodemerchantId() {
		return this.codemerchantId;
	}

	public void setNotifyMethod(String notifyMethod) {
		this.notifyMethod = notifyMethod;
	}

	public String getNotifyMethod() {
		return this.notifyMethod;
	}

	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}

	public Long getOrderId() {
		return this.orderId;
	}

	public String getApiMethodName() {
		return "taobao.vmarket.eticket.manage.notify";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("codemerchant_id", this.codemerchantId);
		txtParams.put("notify_method", this.notifyMethod);
		txtParams.put("order_id", this.orderId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<VmarketEticketManageNotifyResponse> getResponseClass() {
		return VmarketEticketManageNotifyResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(notifyMethod, "notifyMethod");
		RequestCheckUtils.checkNotEmpty(orderId, "orderId");
	}
	

}