package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.VmarketEticketPackageBaseGetResponse;

/**
 * TOP API: taobao.vmarket.eticket.package.base.get request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class VmarketEticketPackageBaseGetRequest extends BaseTaobaoRequest<VmarketEticketPackageBaseGetResponse> {
	
	

	/** 
	* 包id
	 */
	private Long packageId;

	public void setPackageId(Long packageId) {
		this.packageId = packageId;
	}

	public Long getPackageId() {
		return this.packageId;
	}

	public String getApiMethodName() {
		return "taobao.vmarket.eticket.package.base.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("package_id", this.packageId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<VmarketEticketPackageBaseGetResponse> getResponseClass() {
		return VmarketEticketPackageBaseGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(packageId, "packageId");
	}
	

}