package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;
import java.util.HashMap;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.FileItem;
import com.taobao.api.TaobaoUploadRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.VmarketEticketQrcodeUploadResponse;

/**
 * TOP API: taobao.vmarket.eticket.qrcode.upload request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class VmarketEticketQrcodeUploadRequest extends BaseTaobaoRequest<VmarketEticketQrcodeUploadResponse> implements TaobaoUploadRequest<VmarketEticketQrcodeUploadResponse> {

	
	

	/** 
	* 码商ID
	 */
	private Long codeMerchantId;

	/** 
	* 上传的图片byte[]  小于300K，图片尺寸400*400以内
	 */
	private FileItem imgBytes;

	public void setCodeMerchantId(Long codeMerchantId) {
		this.codeMerchantId = codeMerchantId;
	}

	public Long getCodeMerchantId() {
		return this.codeMerchantId;
	}

	public void setImgBytes(FileItem imgBytes) {
		this.imgBytes = imgBytes;
	}

	public FileItem getImgBytes() {
		return this.imgBytes;
	}

	public String getApiMethodName() {
		return "taobao.vmarket.eticket.qrcode.upload";
	}

	public Map<String, String> getTextParams() {
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("code_merchant_id", this.codeMerchantId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<VmarketEticketQrcodeUploadResponse> getResponseClass() {
		return VmarketEticketQrcodeUploadResponse.class;
	}

	public void check() throws ApiRuleException {
		
		RequestCheckUtils.checkNotEmpty(codeMerchantId, "codeMerchantId");
		RequestCheckUtils.checkNotEmpty(imgBytes, "imgBytes");
	}

	public Map<String, FileItem> getFileParams() {
		Map<String, FileItem> params = new HashMap<String, FileItem>();
		params.put("img_bytes", this.imgBytes);
		return params;
	}
	
	

}