package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.VmarketEticketReverseResponse;

/**
 * TOP API: taobao.vmarket.eticket.reverse request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class VmarketEticketReverseRequest extends BaseTaobaoRequest<VmarketEticketReverseResponse> {
	
	

	/** 
	* 码商ID，是码商的话必须传递，如果是信任卖家不要传
	 */
	private Long codemerchantId;

	/** 
	* 需要冲正的核销记录对应核销流水号（对应的核销操作时候传递的自定义流水号）
	 */
	private String consumeSecialNum;

	/** 
	* 进行验码的电子凭证订单的订单ID
	 */
	private Long orderId;

	/** 
	* 机具id，如果是码商必须传，如果是信任卖家不要传
	 */
	private String posid;

	/** 
	* 不需要上传二维码图片或者冲正后不需要变更码的请不要传，需要传入二维码的码商请先调用taobao.vmarket.eticket.qrcode.upload接口，将返回的img_filename文件名称作为参数，多个文件名用逗号隔开且与参数verify_codes按从左到有的顺序一一对应。
	 */
	private String qrImages;

	/** 
	* 冲正的码，只支持单个码
	 */
	private String reverseCode;

	/** 
	* 冲正份数（必须是和被冲正的核销记录的份数一致）
	 */
	private Long reverseNum;

	/** 
	* 安全验证token，需要和该订单发码通知中的token一致
	 */
	private String token;

	/** 
	* 所有冲正后需要重新生成的码和对应的次数。码和次数之间用英文冒号分隔，多个码之间用英文逗号分隔。如果冲正后不需要重新生成码，留空
	 */
	private String verifyCodes;

	public void setCodemerchantId(Long codemerchantId) {
		this.codemerchantId = codemerchantId;
	}

	public Long getCodemerchantId() {
		return this.codemerchantId;
	}

	public void setConsumeSecialNum(String consumeSecialNum) {
		this.consumeSecialNum = consumeSecialNum;
	}

	public String getConsumeSecialNum() {
		return this.consumeSecialNum;
	}

	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}

	public Long getOrderId() {
		return this.orderId;
	}

	public void setPosid(String posid) {
		this.posid = posid;
	}

	public String getPosid() {
		return this.posid;
	}

	public void setQrImages(String qrImages) {
		this.qrImages = qrImages;
	}

	public String getQrImages() {
		return this.qrImages;
	}

	public void setReverseCode(String reverseCode) {
		this.reverseCode = reverseCode;
	}

	public String getReverseCode() {
		return this.reverseCode;
	}

	public void setReverseNum(Long reverseNum) {
		this.reverseNum = reverseNum;
	}

	public Long getReverseNum() {
		return this.reverseNum;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getToken() {
		return this.token;
	}

	public void setVerifyCodes(String verifyCodes) {
		this.verifyCodes = verifyCodes;
	}

	public String getVerifyCodes() {
		return this.verifyCodes;
	}

	public String getApiMethodName() {
		return "taobao.vmarket.eticket.reverse";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("codemerchant_id", this.codemerchantId);
		txtParams.put("consume_secial_num", this.consumeSecialNum);
		txtParams.put("order_id", this.orderId);
		txtParams.put("posid", this.posid);
		txtParams.put("qr_images", this.qrImages);
		txtParams.put("reverse_code", this.reverseCode);
		txtParams.put("reverse_num", this.reverseNum);
		txtParams.put("token", this.token);
		txtParams.put("verify_codes", this.verifyCodes);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<VmarketEticketReverseResponse> getResponseClass() {
		return VmarketEticketReverseResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(consumeSecialNum, "consumeSecialNum");
		RequestCheckUtils.checkNotEmpty(orderId, "orderId");
		RequestCheckUtils.checkNotEmpty(reverseCode, "reverseCode");
		RequestCheckUtils.checkNotEmpty(reverseNum, "reverseNum");
		RequestCheckUtils.checkNotEmpty(token, "token");
	}
	

}